/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.FileLock;

public class TestOsSpecificLocks {
    private String path;

    @Before
    public void doBefore() {
        this.path = AbstractNeo4jTestCase.getStorePath("checkLocks");
        AbstractNeo4jTestCase.deleteFileOrDirectory(this.path);
        new File(this.path).mkdirs();
    }

    @Test
    public void sanityCheck() throws Exception {
        Assume.assumeTrue((boolean)GraphDatabaseSetting.osIsWindows());
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String fileName = this.path + "\\1neostore";
        FileChannel channel = fs.open(fileName, "rw");
        FileLock lock = fs.tryLock(fileName, channel);
        Assert.assertTrue((boolean)new File(this.path + "\\lock").exists());
        Assert.assertNull((Object)fs.tryLock(fileName, channel));
        FileChannel tempChannel = fs.open(fileName + "1", "rw");
        FileLock tempLock = fs.tryLock(fileName + "1", tempChannel);
        Assert.assertNotNull((Object)tempLock);
        tempLock.release();
        tempChannel.close();
        lock.release();
        Assert.assertFalse((boolean)new File(this.path + "\\lock").exists());
        fs.tryLock(fileName, channel).release();
        Assert.assertFalse((boolean)new File(this.path + "\\lock").exists());
    }

    @Test
    public void testDatabaseLocking() {
        Assume.assumeTrue((boolean)GraphDatabaseSetting.osIsWindows());
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.path);
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Assert.assertTrue((boolean)new File(this.path + "\\lock").exists());
        try {
            new GraphDatabaseFactory().newEmbeddedDatabase(this.path);
            Assert.fail((String)"Should not be able to start up another db in the same dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        db.shutdown();
    }
}

