/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class TestPropertyIndex {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lazyLoadWithinWriteTransaction() throws Exception {
        File dir = TargetDirectory.forTest(this.getClass()).graphDbDir(true);
        BatchInserter inserter = BatchInserters.inserter((String)dir.getAbsolutePath());
        int count = 3000;
        long nodeId = inserter.createNode(this.mapWithManyProperties(count));
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(dir.getAbsolutePath());
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            Node node = db.getNodeById(nodeId);
            Assert.assertEquals((long)count, (long)IteratorUtil.count((Iterable)node.getPropertyKeys()));
            tx.success();
        }
        finally {
            tx.finish();
            db.shutdown();
        }
    }

    private Map<String, Object> mapWithManyProperties(int count) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            properties.put("key:" + i, "value");
        }
        return properties;
    }
}

