/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.StringLogger;

@AbstractNeo4jTestCase.RequiresPersistentGraphDatabase
public class TestXa
extends AbstractNeo4jTestCase {
    private NeoStoreXaDataSource ds;
    private NeoStoreXaConnection xaCon;
    private Logger log;
    private Level level;
    private Map<String, PropertyIndex> propertyIndexes;
    private LockManager lockManager;
    private LockReleaser lockReleaser;

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    private String path() {
        String path = TestXa.getStorePath("xatest");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    @BeforeClass
    public static void deleteFiles() {
        TestXa.deleteFileOrDirectory(TestXa.getStorePath("xatest"));
    }

    @Before
    public void setUpNeoStore() throws Exception {
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.level = this.log.getLevel();
        this.log.setLevel(Level.OFF);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(Level.OFF);
        TestXa.deleteFileOrDirectory(new File(this.path()));
        this.propertyIndexes = new HashMap<String, PropertyIndex>();
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        StoreFactory sf = new StoreFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(Collections.emptyMap())), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.DEV_NULL, null);
        sf.createNeoStore(this.file("neo")).close();
        this.lockManager = this.getEmbeddedGraphDb().getLockManager();
        this.lockReleaser = this.getEmbeddedGraphDb().getLockReleaser();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
    }

    @After
    public void tearDownNeoStore() {
        this.ds.close();
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(this.level);
        File file = new File(this.file("neo"));
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.nodestore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.nodestore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.keys"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.keys.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.strings"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.strings.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.arrays"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.arrays.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshipstore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshipstore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.names"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.names.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        file = new File(this.path());
        for (File nioFile : file.listFiles()) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            Assert.assertTrue((String)("Couldn't delete '" + nioFile.getPath() + "'"), (boolean)nioFile.delete());
        }
    }

    private void deleteLogicalLogIfExist() {
        File file = new File(this.file("nioneo_logical.log.1"));
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("nioneo_logical.log.2"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        file = new File(this.file("nioneo_logical.log.active"));
        Assert.assertTrue((boolean)file.delete());
    }

    public static void renameCopiedLogicalLog(String storeDir) {
        for (File file : new File(storeDir).listFiles()) {
            if (!file.getName().contains(".bak.")) continue;
            String nameWithoutBak = file.getName().replaceAll("\\.bak", "");
            File targetFile = new File(file.getParent(), nameWithoutBak);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            Assert.assertTrue((boolean)file.renameTo(targetFile));
        }
    }

    private void truncateLogicalLog(int size) throws IOException {
        char active = '1';
        FileChannel af = new RandomAccessFile(this.file("nioneo_logical.log.active"), "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        af.close();
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        FileChannel fileChannel = new RandomAccessFile(this.file("nioneo_logical.log." + active), "rw").getChannel();
        if (fileChannel.size() > (long)size) {
            fileChannel.truncate(size);
        } else {
            fileChannel.position(size);
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put((byte)0).flip();
            fileChannel.write(buf);
        }
        fileChannel.force(false);
        fileChannel.close();
    }

    public static Pair<Pair<File, File>, Pair<File, File>> copyLogicalLog(String storeDir) throws IOException {
        char active = '1';
        File activeLog = new File(storeDir, "nioneo_logical.log.active");
        FileChannel af = new RandomAccessFile(activeLog, "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        buffer.flip();
        File activeLogBackup = new File(storeDir, "nioneo_logical.log.bak.active");
        FileChannel activeCopy = new RandomAccessFile(activeLogBackup, "rw").getChannel();
        activeCopy.write(buffer);
        activeCopy.close();
        af.close();
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        File currentLog = new File(storeDir, "nioneo_logical.log." + active);
        FileChannel source = new RandomAccessFile(currentLog, "r").getChannel();
        File currentLogBackup = new File(storeDir, "nioneo_logical.log.bak." + active);
        FileChannel dest = new RandomAccessFile(currentLogBackup, "rw").getChannel();
        int read = -1;
        do {
            read = source.read(buffer);
            buffer.flip();
            dest.write(buffer);
            buffer.clear();
        } while (read == 1024);
        source.close();
        dest.close();
        return Pair.of((Object)Pair.of((Object)activeLog, (Object)activeLogBackup), (Object)Pair.of((Object)currentLog, (Object)currentLogBackup));
    }

    private PropertyIndex index(String key) {
        PropertyIndex result = this.propertyIndexes.get(key);
        if (result != null) {
            return result;
        }
        int id = (int)this.ds.nextId(PropertyIndex.class);
        MyPropertyIndex index = new MyPropertyIndex(key, id);
        this.propertyIndexes.put(key, index);
        this.xaCon.getWriteTransaction().createPropertyIndex(key, id);
        return index;
    }

    @Test
    public void testLogicalLog() throws Exception {
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        this.xaCon.getWriteTransaction().nodeLoadProperties(node1, false);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, node1, node2);
        PropertyData r1prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        n1prop1 = this.xaCon.getWriteTransaction().nodeChangeProperty(node1, n1prop1, (Object)"string2");
        r1prop1 = this.xaCon.getWriteTransaction().relChangeProperty(rel1, r1prop1, (Object)"string2");
        this.xaCon.getWriteTransaction().nodeRemoveProperty(node1, n1prop1);
        this.xaCon.getWriteTransaction().relRemoveProperty(rel1, r1prop1);
        this.xaCon.getWriteTransaction().relDelete(rel1);
        this.xaCon.getWriteTransaction().nodeDelete(node1);
        this.xaCon.getWriteTransaction().nodeDelete(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    private NeoStoreXaDataSource newNeoStore() throws InstantiationException, IOException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Config config = new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), this.path(), InternalAbstractGraphDatabase.Configuration.neo_store.name(), this.file("neo"), InternalAbstractGraphDatabase.Configuration.logical_log.name(), this.file("nioneo_logical.log")})));
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.DEV_NULL, null);
        PlaceboTm txManager = new PlaceboTm();
        DefaultLogBufferFactory logBufferFactory = new DefaultLogBufferFactory();
        for (File file : new File(this.path()).listFiles()) {
            if (!file.isFile() || !file.getName().startsWith("nioneo_logical.log.v")) continue;
            file.delete();
        }
        return new NeoStoreXaDataSource(config, sf, (FileSystemAbstraction)fileSystem, this.lockManager, this.lockReleaser, StringLogger.DEV_NULL, new XaFactory(config, TxIdGenerator.DEFAULT, (AbstractTransactionManager)txManager, (LogBufferFactory)logBufferFactory, (FileSystemAbstraction)fileSystem, StringLogger.DEV_NULL, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING), Collections.emptyList(), null);
    }

    @Test
    public void testLogicalLogPrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, node1, node2);
        PropertyData r1prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        this.xaCon.getWriteTransaction().nodeChangeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getWriteTransaction().relChangeProperty(rel1, r1prop1, (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogicalLogPreparedPropertyBlocks() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        PropertyData n1prop2 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getWriteTransaction().nodeRemoveProperty(node1, n1prop1);
        this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void makeSureRecordsAreCreated() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)new long[]{Integer.MIN_VALUE, 1L, 1L});
        this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{Integer.MIN_VALUE, 1L, 1L});
        PropertyData toRead = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)new long[]{Integer.MIN_VALUE, 1L, 1L});
        PropertyData toDelete = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop4"), (Object)new long[]{Integer.MIN_VALUE, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getWriteTransaction().nodeRemoveProperty(node1, toDelete);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        Assert.assertTrue((boolean)Arrays.equals((long[])toRead.getValue(), (long[])((PropertyData)this.xaCon.getWriteTransaction().nodeLoadProperties(node1, false).get((Object)toRead.getIndex())).getValue()));
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
    }

    @Test
    public void testDynamicRecordsInLog() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        PropertyData toChange = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"hi");
        PropertyData toRead = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getWriteTransaction().nodeChangeProperty(node1, toChange, (Object)"hI");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        Assert.assertTrue((boolean)Arrays.equals(new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}, (long[])this.xaCon.getWriteTransaction().loadPropertyValue(toRead)));
    }

    @Test
    public void testLogicalLogPrePrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[3], new byte[3]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, node1, node2);
        PropertyData r1prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        this.xaCon.getWriteTransaction().nodeChangeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getWriteTransaction().relChangeProperty(rel1, r1prop1, (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        this.xaCon.clearAllTransactions();
        TestXa.copyLogicalLog(this.path());
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
    }

    @Test
    public void testBrokenNodeCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.truncateLogicalLog(94);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.truncateLogicalLog(94);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenPrepare() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        TestXa.copyLogicalLog(this.path());
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.truncateLogicalLog(243);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenDone() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        TestXa.copyLogicalLog(this.path());
        this.ds.close();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.path());
        this.truncateLogicalLog(264);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogVersion() {
        long creationTime = this.ds.getCreationTime();
        long randomIdentifier = this.ds.getRandomIdentifier();
        long currentVersion = this.ds.getCurrentLogVersion();
        Assert.assertEquals((long)currentVersion, (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)(currentVersion + 1L), (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)creationTime, (long)this.ds.getCreationTime());
        Assert.assertEquals((long)randomIdentifier, (long)this.ds.getRandomIdentifier());
    }

    @Test
    public void testLogicalLogRotation() throws Exception {
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        this.xaCon.getWriteTransaction().nodeLoadProperties(node1, false);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, node1, node2);
        PropertyData r1prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        n1prop1 = this.xaCon.getWriteTransaction().nodeChangeProperty(node1, n1prop1, (Object)"string2");
        r1prop1 = this.xaCon.getWriteTransaction().relChangeProperty(rel1, r1prop1, (Object)"string2");
        this.xaCon.getWriteTransaction().nodeRemoveProperty(node1, n1prop1);
        this.xaCon.getWriteTransaction().relRemoveProperty(rel1, r1prop1);
        this.xaCon.getWriteTransaction().relDelete(rel1);
        this.xaCon.getWriteTransaction().nodeDelete(node1);
        this.xaCon.getWriteTransaction().nodeDelete(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        long currentVersion = this.ds.getCurrentLogVersion();
        this.ds.rotateLogicalLog();
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion));
        this.ds.rotateLogicalLog();
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion));
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion + 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logicalLogExists(long version) throws IOException {
        ReadableByteChannel log = this.ds.getLogicalLog(version);
        try {
            boolean bl = log != null;
            return bl;
        }
        finally {
            log.close();
        }
    }

    private static class MyPropertyIndex
    extends PropertyIndex {
        protected MyPropertyIndex(String key, int keyId) {
            super(key, keyId);
        }
    }
}

