/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameRecord;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

@Ignore
public class UpgradeStoreIT {
    private static final String PATH = "target/var/upgrade";

    @Before
    public void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
    }

    private String path(int i) {
        return new File(PATH, "" + i).getAbsolutePath();
    }

    @Test
    public void makeSureStoreWithTooManyRelationshipTypesCannotBeUpgraded() throws Exception {
        String path = this.path(0);
        new EmbeddedGraphDatabase(path).shutdown();
        this.createManyRelationshipTypes(path, 65536);
        this.assertCannotStart(path, "Shouldn't be able to upgrade with that many types set");
    }

    @Test
    public void makeSureStoreWithDecentAmountOfRelationshipTypesCanBeUpgraded() throws Exception {
        String path = this.path(1);
        new EmbeddedGraphDatabase(path).shutdown();
        this.createManyRelationshipTypes(path, 65535);
        this.assertCanStart(path);
    }

    @Test(expected=TransactionFailureException.class)
    public void makeSureStoreWithTooBigStringBlockSizeCannotBeCreated() throws Exception {
        new EmbeddedGraphDatabase(this.path(2), MapUtil.stringMap((String[])new String[]{"string_block_size", "65536"}));
    }

    @Test
    public void makeSureStoreWithDecentStringBlockSizeCanBeCreated() throws Exception {
        new EmbeddedGraphDatabase(this.path(3), MapUtil.stringMap((String[])new String[]{"string_block_size", "65535"})).shutdown();
    }

    @Test(expected=TransactionFailureException.class)
    public void makeSureStoreWithTooBigArrayBlockSizeCannotBeCreated() throws Exception {
        new EmbeddedGraphDatabase(this.path(4), MapUtil.stringMap((String[])new String[]{"array_block_size", "65536"}));
    }

    @Test
    public void makeSureStoreWithDecentArrayBlockSizeCanBeCreated() throws Exception {
        new EmbeddedGraphDatabase(this.path(5), MapUtil.stringMap((String[])new String[]{"array_block_size", "65535"})).shutdown();
    }

    @Test
    public void makeSureStoreWithTooBigStringBlockSizeCannotBeUpgraded() throws Exception {
        String path = this.path(6);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.strings"), 65536, "StringPropertyStore v0.9.5");
        this.assertCannotStart(path, "Shouldn't be able to upgrade with block size that big");
    }

    @Test
    public void makeSureStoreWithDecentStringBlockSizeCanBeUpgraded() throws Exception {
        String path = this.path(7);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.strings"), 65535, "StringPropertyStore v0.9.5");
        this.assertCanStart(path);
    }

    @Test
    public void makeSureStoreWithTooBigArrayBlockSizeCannotBeUpgraded() throws Exception {
        String path = this.path(8);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.arrays"), 65536, "ArrayPropertyStore v0.9.5");
        this.assertCannotStart(path, "Shouldn't be able to upgrade with block size that big");
    }

    @Test
    public void makeSureStoreWithDecentArrayBlockSizeCanBeUpgraded() throws Exception {
        String path = this.path(9);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.arrays"), 65535, "ArrayPropertyStore v0.9.5");
        this.assertCanStart(path);
    }

    @Test
    public void makeSureLogsAreMovedWhenUpgrading() throws Exception {
        String path = this.path(10);
        for (int i = 0; i < 3; ++i) {
            new EmbeddedGraphDatabase(path, MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "true"})).shutdown();
        }
        this.setOlderNeoStoreVersion(path);
        new EmbeddedGraphDatabase(path, MapUtil.stringMap((String[])new String[]{"allow_store_upgrade", "true"})).shutdown();
        File oldLogDir = new File(path, "1.2-logs");
        Assert.assertTrue((boolean)oldLogDir.exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "nioneo_logical.log.v0").exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "nioneo_logical.log.v1").exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "nioneo_logical.log.v2").exists());
        Assert.assertFalse((boolean)new File(path, "nioneo_logical.log.v0").exists());
        Assert.assertFalse((boolean)new File(path, "nioneo_logical.log.v1").exists());
        Assert.assertFalse((boolean)new File(path, "nioneo_logical.log.v2").exists());
    }

    @Test
    public void makeSureStoreCantBeUpgradedIfNotExplicitlyToldTo() throws Exception {
        block2: {
            String path = this.path(11);
            new EmbeddedGraphDatabase(path).shutdown();
            this.setOlderNeoStoreVersion(path);
            try {
                new EmbeddedGraphDatabase(path);
                Assert.fail((String)"Shouldn't be able to upgrade if not told to");
            }
            catch (TransactionFailureException e) {
                if (e.getCause() instanceof NotCurrentStoreVersionException) break block2;
                throw e;
            }
        }
    }

    @Test
    public void makeSureStoreCantBeUpgradedIfNotExplicitlyToldTo2() throws Exception {
        block2: {
            String path = this.path(12);
            new EmbeddedGraphDatabase(path).shutdown();
            this.setOlderNeoStoreVersion(path);
            try {
                new EmbeddedGraphDatabase(path, MapUtil.stringMap((String[])new String[]{"allow_store_upgrade", "false"}));
                Assert.fail((String)"Shouldn't be able to upgrade if not told to");
            }
            catch (TransactionFailureException e) {
                if (e.getCause() instanceof NotCurrentStoreVersionException) break block2;
                throw e;
            }
        }
    }

    @Test
    public void makeSureStoreCanBeUpgradedIfExplicitlyToldTo() throws Exception {
        String path = this.path(13);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setOlderNeoStoreVersion(path);
        new EmbeddedGraphDatabase(path, MapUtil.stringMap((String[])new String[]{"allow_store_upgrade", "true"})).shutdown();
    }

    @Test
    public void makeSureStoreCantBeUpgradedByBatchInserterEvenIfExplicitlyToldTo() throws Exception {
        String path = this.path(14);
        new EmbeddedGraphDatabase(path).shutdown();
        this.setOlderNeoStoreVersion(path);
        try {
            new BatchInserterImpl(path, MapUtil.stringMap((String[])new String[]{"allow_store_upgrade", "true"}));
            Assert.fail((String)"Shouldn't be able to upgrade with batch inserter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCannotStart(String path, String failMessage) {
        EmbeddedGraphDatabase db = null;
        try {
            db = new EmbeddedGraphDatabase(path);
            Assert.fail((String)failMessage);
        }
        catch (TransactionFailureException e) {
            if (!(e.getCause() instanceof NotCurrentStoreVersionException)) {
                throw e;
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCanStart(String path) {
        EmbeddedGraphDatabase db = null;
        try {
            db = new EmbeddedGraphDatabase(path);
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    private void setOlderNeoStoreVersion(String path) throws IOException {
        String oldVersion = "NeoStore v0.9.6";
        FileChannel channel = new RandomAccessFile(new File(path, "neostore"), "rw").getChannel();
        channel.position(channel.size() - (long)UTF8.encode((String)oldVersion).length);
        ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode((String)oldVersion));
        channel.write(buffer);
        channel.close();
    }

    private void setBlockSize(File file, int blockSize, String oldVersionToSet) throws IOException {
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4]);
        buffer.putInt(blockSize + 8);
        buffer.flip();
        channel.write(buffer);
        channel.position(channel.size() - (long)UTF8.encode((String)oldVersionToSet).length);
        buffer = ByteBuffer.wrap(UTF8.encode((String)oldVersionToSet));
        channel.write(buffer);
        channel.close();
    }

    private void createManyRelationshipTypes(String path, int numberOfTypes) {
        String fileName = new File(path, "neostore.relationshiptypestore.db").getAbsolutePath();
        DynamicStringStore stringStore = new DynamicStringStore(fileName + ".names", null, IdType.RELATIONSHIP_TYPE_BLOCK, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.SYSTEM);
        RelationshipTypeStoreWithOneOlderVersion store = new RelationshipTypeStoreWithOneOlderVersion(fileName, stringStore);
        for (int i = 0; i < numberOfTypes; ++i) {
            String name = "type" + i;
            RelationshipTypeRecord record = new RelationshipTypeRecord(i);
            record.setCreated();
            record.setInUse(true);
            int nameId = store.nextNameId();
            record.setNameId(nameId);
            Collection typeRecords = store.allocateNameRecords(nameId, PropertyStore.encodeString((String)name));
            for (DynamicRecord typeRecord : typeRecords) {
                record.addNameRecord(typeRecord);
            }
            store.setHighId(store.getHighId() + 1L);
            store.updateRecord((AbstractNameRecord)record);
        }
        store.close();
    }

    private static class NoLimitIdGeneratorFactory
    implements IdGeneratorFactory {
        private final Map<IdType, IdGenerator> generators = new HashMap<IdType, IdGenerator>();

        private NoLimitIdGeneratorFactory() {
        }

        public IdGenerator open(FileSystemAbstraction fs, String fileName, int grabSize, IdType idType, long highestIdInUse, boolean startup) {
            IdGeneratorImpl generator = new IdGeneratorImpl(fs, fileName, grabSize, Long.MAX_VALUE, false);
            this.generators.put(idType, (IdGenerator)generator);
            return generator;
        }

        public IdGenerator get(IdType idType) {
            return this.generators.get(idType);
        }

        public void create(FileSystemAbstraction fs, String fileName) {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)fs, (String)fileName);
        }
    }

    private static class RelationshipTypeStoreWithOneOlderVersion
    extends RelationshipTypeStore {
        private boolean versionCalled;

        public RelationshipTypeStoreWithOneOlderVersion(String fileName, DynamicStringStore stringStore) {
            super(fileName, new Config(MapUtil.stringMap((String[])new String[0])), (IdGeneratorFactory)new NoLimitIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.SYSTEM, stringStore);
        }

        public String getTypeDescriptor() {
            if (!this.versionCalled) {
                this.versionCalled = true;
                return super.getTypeDescriptor();
            }
            return "RelationshipTypeStore v0.9.5";
        }
    }
}

