/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionReader;

public class TransactionWriterTest {
    private final Map<Class<?>, Comparison> comparisons = new HashMap();

    @Test
    public void shouldWriteTransaction() throws Exception {
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        TransactionWriter writer = new TransactionWriter((LogBuffer)buffer, 1);
        NodeRecord node = new NodeRecord(0L, -1L, -1L);
        RelationshipRecord relationship = new RelationshipRecord(0L, 1L, 1L, 6);
        writer.start(1, 1);
        writer.create(node);
        writer.update(relationship);
        writer.delete(new PropertyRecord(3L));
        writer.prepare();
        writer.commit(false, 17L);
        writer.done();
        TransactionReader.Visitor visitor = TransactionWriterTest.visited((ReadableByteChannel)buffer);
        InOrder order = Mockito.inOrder((Object[])new Object[]{visitor});
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitStart(Matchers.eq((int)1), (byte[])Matchers.any(byte[].class), Matchers.eq((int)1), Matchers.eq((int)1), Matchers.anyLong());
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitUpdateNode(Matchers.eq((int)1), (NodeRecord)Matchers.argThat(this.matchesRecord(node)));
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitUpdateRelationship(Matchers.eq((int)1), (RelationshipRecord)Matchers.argThat(this.matchesRecord(relationship)));
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitDeleteProperty(Matchers.eq((int)1), Matchers.eq((long)3L));
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitPrepare(Matchers.eq((int)1), Matchers.anyLong());
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitCommit(Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((long)17L), Matchers.anyLong());
        ((TransactionReader.Visitor)order.verify((Object)visitor)).visitDone(Matchers.eq((int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    private static TransactionReader.Visitor visited(ReadableByteChannel source) throws IOException {
        TransactionReader.Visitor visitor = (TransactionReader.Visitor)Mockito.mock(TransactionReader.Visitor.class);
        new TransactionReader().read(source, visitor);
        return visitor;
    }

    private <T extends AbstractBaseRecord> Matcher<T> matchesRecord(final T record) {
        final Comparison comparison = this.comparison(record.getClass());
        return new TypeSafeMatcher<T>(record.getClass()){

            public boolean matchesSafely(T item) {
                return comparison.compare(record, item);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)record);
            }
        };
    }

    private Comparison comparison(Class<?> type) {
        Comparison comparison = this.comparisons.get(type);
        if (comparison == null) {
            comparison = new Comparison(type);
            this.comparisons.put(type, comparison);
        }
        return comparison;
    }

    private static class Comparison {
        private final Collection<Field> fields = new ArrayList<Field>();

        Comparison(Class<?> type) {
            for (Field field : type.getDeclaredFields()) {
                if (field.getDeclaringClass() != type) continue;
                field.setAccessible(true);
                this.fields.add(field);
            }
        }

        boolean compare(Object expected, Object actual) {
            try {
                for (Field field : this.fields) {
                    if (Comparison.equal(field.get(expected), field.get(actual))) continue;
                    return false;
                }
                return true;
            }
            catch (Exception failure) {
                return false;
            }
        }

        private static boolean equal(Object a, Object b) {
            return a == b || a != null && (a.equals(b) || b != null && Comparison.deepEquals(a, b));
        }

        private static boolean deepEquals(Object a, Object b) {
            if (a.getClass() == b.getClass() && a.getClass().isArray()) {
                if (a instanceof Object[]) {
                    return Arrays.deepEquals((Object[])a, (Object[])b);
                }
                if (a instanceof byte[]) {
                    return Arrays.equals((byte[])a, (byte[])b);
                }
                if (a instanceof char[]) {
                    return Arrays.equals((char[])a, (char[])b);
                }
            }
            return false;
        }
    }
}

