/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.junit.Assert;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.storemigration.StoreFiles;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.util.FileUtils;

public class MigrationTestUtils {
    public static Config defaultConfig() {
        return MigrationTestUtils.defaultConfig(MapUtil.stringMap((String[])new String[0]));
    }

    public static Config defaultConfig(Map<String, String> inputParams) {
        return new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(inputParams));
    }

    public static int[] makeLongArray() {
        int[] longArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            longArray[i] = i;
        }
        return longArray;
    }

    static String makeLongString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("characters");
        }
        return builder.toString();
    }

    static void changeVersionNumber(File storeFile, String versionString) throws IOException {
        byte[] versionBytes = UTF8.encode((String)versionString);
        FileChannel fileChannel = new RandomAccessFile(storeFile, "rw").getChannel();
        fileChannel.position(storeFile.length() - (long)versionBytes.length);
        fileChannel.write(ByteBuffer.wrap(versionBytes));
        fileChannel.close();
    }

    static void truncateFile(File storeFile, String suffixToDetermineTruncationLength) throws IOException {
        byte[] versionBytes = UTF8.encode((String)suffixToDetermineTruncationLength);
        FileChannel fileChannel = new RandomAccessFile(storeFile, "rw").getChannel();
        fileChannel.truncate(storeFile.length() - (long)versionBytes.length);
        fileChannel.close();
    }

    static void truncateToFixedLength(File storeFile, int newLength) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(storeFile, "rw").getChannel();
        fileChannel.truncate(newLength);
        fileChannel.close();
    }

    public static void prepareSampleLegacyDatabase(File workingDirectory) throws IOException {
        File resourceDirectory = MigrationTestUtils.findOldFormatStoreDirectory();
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }

    public static File findOldFormatStoreDirectory() {
        URL legacyStoreResource = LegacyStore.class.getResource("exampledb/neostore");
        return new File(legacyStoreResource.getFile()).getParentFile();
    }

    public static boolean allStoreFilesHaveVersion(File workingDirectory, String version) throws IOException {
        for (String fileName : StoreFiles.fileNames) {
            FileChannel channel = new RandomAccessFile(new File(workingDirectory, fileName), "r").getChannel();
            int length = UTF8.encode((String)version).length;
            byte[] bytes = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(channel.size() - (long)length);
            channel.read(buffer);
            channel.close();
            String foundVersion = UTF8.decode((byte[])bytes);
            if (version.equals(foundVersion)) continue;
            return false;
        }
        return true;
    }

    public static void verifyFilesHaveSameContent(File original, File other) throws IOException {
        for (File originalFile : original.listFiles()) {
            int aByte;
            File otherFile = new File(other, originalFile.getName());
            if (originalFile.isDirectory()) continue;
            BufferedInputStream originalStream = new BufferedInputStream(new FileInputStream(originalFile));
            BufferedInputStream otherStream = new BufferedInputStream(new FileInputStream(otherFile));
            while ((aByte = originalStream.read()) != -1) {
                Assert.assertEquals((String)("Different content in " + originalFile.getName()), (long)aByte, (long)otherStream.read());
            }
            originalStream.close();
            otherStream.close();
        }
    }

    public static UpgradeConfiguration alwaysAllowed() {
        return new AlwaysAllowedUpgradeConfiguration();
    }

    static class AlwaysAllowedUpgradeConfiguration
    implements UpgradeConfiguration {
        AlwaysAllowedUpgradeConfiguration() {
        }

        public void checkConfigurationAllowsAutomaticUpgrade() {
        }
    }
}

