/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.ProduceUncleanStore;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;

public class NeoStoreVersionRecordUpgradeIssueIT {
    @Rule
    public final TestName testName = new TestName();

    @Test
    public void upgradeOneFiveMilestoneTwoWhereStoreVersionRecordShouldBeAddedCorrectly() throws Exception {
        File storeDir = this.copyResourceStore("1.5.M02-store");
        this.startAndShutdown(storeDir);
        this.startAndKill(storeDir);
        this.startAndShutdown(storeDir);
    }

    private void startAndKill(File storeDir) throws Exception {
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir.getAbsolutePath()}).waitFor());
    }

    private void startAndShutdown(File storeDir) {
        new EmbeddedGraphDatabase(storeDir.getAbsolutePath()).shutdown();
    }

    private File copyResourceStore(String resource) throws Exception {
        URL uri = this.getClass().getResource(resource);
        File file = new File(uri.toURI());
        File target = TargetDirectory.forTest(this.getClass()).directory(this.testName.getMethodName(), true);
        FileUtils.copyRecursively((File)file, (File)target);
        return target;
    }
}

