/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.PropertyWriter;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class PropertyWriterTestIT {
    private NeoStore neoStore;

    private PropertyStore newPropertyStore() throws IOException {
        Config config = MigrationTestUtils.defaultConfig();
        File outputDir = new File("target/outputDatabase");
        FileUtils.deleteRecursively((File)outputDir);
        Assert.assertTrue((boolean)outputDir.mkdirs());
        File fileName = new File(outputDir, "neostore");
        StoreFactory storeFactory = new StoreFactory(config, CommonFactories.defaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), CommonFactories.defaultFileSystemAbstraction(), CommonFactories.defaultLastCommittedTxIdSetter(), StringLogger.DEV_NULL, CommonFactories.defaultTxHook());
        this.neoStore = storeFactory.createNeoStore(fileName.getAbsolutePath());
        return this.neoStore.getPropertyStore();
    }

    @After
    public void close() {
        this.neoStore.close();
    }

    @Test
    public void shouldPackASeriesOfPropertiesIntoAPropertyRecord() throws IOException {
        PropertyStore propertyStore = this.newPropertyStore();
        Assert.assertEquals((long)0L, (long)propertyStore.getHighId());
        PropertyWriter propertyWriter = new PropertyWriter(propertyStore);
        ArrayList<Pair> properties = new ArrayList<Pair>();
        properties.add(Pair.of((Object)0, (Object)1234));
        properties.add(Pair.of((Object)1, (Object)5678));
        long propertyRecordId = propertyWriter.writeProperties(properties);
        Assert.assertEquals((long)1L, (long)propertyStore.getHighId());
        Assert.assertEquals((long)0L, (long)propertyRecordId);
        ArrayList propertyBlocks = new ArrayList(propertyStore.getRecord(propertyRecordId).getPropertyBlocks());
        Assert.assertEquals((long)0L, (long)((PropertyBlock)propertyBlocks.get(0)).getKeyIndexId());
        Assert.assertEquals((long)1234L, (long)((PropertyBlock)propertyBlocks.get(0)).getSingleValueInt());
        Assert.assertEquals((long)1L, (long)((PropertyBlock)propertyBlocks.get(1)).getKeyIndexId());
        Assert.assertEquals((long)5678L, (long)((PropertyBlock)propertyBlocks.get(1)).getSingleValueInt());
        propertyStore.close();
    }

    @Test
    public void shouldStoreMultiplePropertiesAcrossASeriesOfRecords() throws IOException {
        int OneBlockPropertyBlockCount = 100;
        PropertyStore propertyStore = this.newPropertyStore();
        Assert.assertEquals((long)0L, (long)propertyStore.getHighId());
        PropertyWriter propertyWriter = new PropertyWriter(propertyStore);
        ArrayList<Pair> properties = new ArrayList<Pair>();
        for (int i = 0; i < 100; ++i) {
            properties.add(Pair.of((Object)i, (Object)i));
        }
        long propertyRecordId = propertyWriter.writeProperties(properties);
        Assert.assertEquals((long)(100 / PropertyType.getPayloadSizeLongs()), (long)propertyStore.getHighId());
        Assert.assertEquals((long)0L, (long)propertyRecordId);
        ArrayList propertyBlocks = new ArrayList();
        PropertyRecord propertyRecord = propertyStore.getRecord(0L);
        propertyBlocks.addAll(propertyStore.getRecord(propertyRecordId).getPropertyBlocks());
        while (propertyRecord.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            long currentRecordId = propertyRecord.getId();
            propertyRecord = propertyStore.getRecord(propertyRecord.getNextProp());
            Assert.assertEquals((long)currentRecordId, (long)propertyRecord.getPrevProp());
            propertyBlocks.addAll(propertyStore.getRecord(propertyRecordId).getPropertyBlocks());
        }
        Assert.assertEquals((long)100L, (long)propertyBlocks.size());
        propertyStore.close();
    }
}

