/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreUpgraderTestIT;

public class StoreUpgradeIntegrationTest {
    @Test
    public void shouldUpgradeAutomaticallyOnDatabaseStartup() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName());
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("allow_store_upgrade", "true");
        EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(workingDirectory.getPath(), params);
        database.shutdown();
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.A.0"));
    }

    @Test
    public void shouldAbortOnNonCleanlyShutdown() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldAbordOnNonCleanlyShutdown");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        StoreUpgraderTestIT.truncateAllFiles(workingDirectory);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("allow_store_upgrade", "true");
        try {
            EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(workingDirectory.getPath(), params);
            Assert.fail((String)"Should have been unable to start upgrade on old version");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldAbortOnCorruptStore() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldAbortOnCorruptStore");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        MigrationTestUtils.truncateFile(new File(workingDirectory, "neostore.propertystore.db.index.keys"), "StringPropertyStore v0.9.9");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("allow_store_upgrade", "true");
        try {
            EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(workingDirectory.getPath(), params);
            Assert.fail((String)"Should have been unable to start upgrade on old version");
        }
        catch (StoreUpgrader.UnableToUpgradeException unableToUpgradeException) {
            // empty catch block
        }
    }
}

