/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecordFetcher;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipTypeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class ReadRecordsTestIT {
    @Test
    public void shouldReadNodeRecords() throws IOException {
        URL nodeStoreFile = this.getClass().getResource("exampledb/neostore.nodestore.db");
        LegacyNodeStoreReader nodeStoreReader = new LegacyNodeStoreReader(nodeStoreFile.getFile());
        Assert.assertEquals((long)1001L, (long)nodeStoreReader.getMaxId());
        Iterable records = nodeStoreReader.readNodeStore();
        int nodeCount = 0;
        for (NodeRecord record : records) {
            if (!record.inUse()) continue;
            ++nodeCount;
        }
        Assert.assertEquals((long)501L, (long)nodeCount);
        nodeStoreReader.close();
    }

    @Test
    public void shouldReadRelationshipRecords() throws IOException {
        URL nodeStoreFile = this.getClass().getResource("exampledb/neostore.relationshipstore.db");
        LegacyRelationshipStoreReader relationshipStoreReader = new LegacyRelationshipStoreReader(nodeStoreFile.getFile());
        Assert.assertEquals((long)1500L, (long)relationshipStoreReader.getMaxId());
        Iterable records = relationshipStoreReader.readRelationshipStore();
        int relationshipCount = 0;
        for (RelationshipRecord record : records) {
            if (!record.inUse()) continue;
            ++relationshipCount;
        }
        Assert.assertEquals((long)500L, (long)relationshipCount);
        relationshipStoreReader.close();
    }

    @Test
    public void shouldReadASimplePropertyRecordById() throws IOException {
        URL propertyStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db");
        LegacyPropertyRecord propertyRecord = new LegacyPropertyStoreReader(propertyStoreFile.getFile()).readPropertyRecord(24L);
        int keyIndexId = propertyRecord.getKeyIndexId();
        Assert.assertEquals((long)2L, (long)keyIndexId);
        Object value = propertyRecord.getType().getValue(propertyRecord, null);
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)value);
    }

    @Test
    public void shouldReadAStringPropertyRecordById() throws IOException {
        URL propertyStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db");
        URL stringStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db.strings");
        URL arrayStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db.arrays");
        LegacyPropertyRecord propertyRecord = new LegacyPropertyStoreReader(propertyStoreFile.getFile()).readPropertyRecord(25L);
        int keyIndexId = propertyRecord.getKeyIndexId();
        Assert.assertEquals((long)3L, (long)keyIndexId);
        Object value = propertyRecord.getType().getValue(propertyRecord, new LegacyDynamicRecordFetcher(stringStoreFile.getFile(), arrayStoreFile.getFile()));
        Assert.assertEquals((long)1000L, (long)((String)value).length());
    }

    @Test
    public void shouldReadAnArrayPropertyRecordById() throws IOException {
        URL propertyStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db");
        URL stringStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db.strings");
        URL arrayStoreFile = this.getClass().getResource("exampledb/neostore.propertystore.db.arrays");
        LegacyPropertyRecord propertyRecord2 = new LegacyPropertyStoreReader(propertyStoreFile.getFile()).readPropertyRecord(32L);
        int keyIndexId = propertyRecord2.getKeyIndexId();
        Assert.assertEquals((long)10L, (long)keyIndexId);
        Object value = propertyRecord2.getType().getValue(propertyRecord2, new LegacyDynamicRecordFetcher(stringStoreFile.getFile(), arrayStoreFile.getFile()));
        Assert.assertArrayEquals((int[])MigrationTestUtils.makeLongArray(), (int[])((int[])value));
    }

    @Test
    public void shouldReadPropertyIndexRecords() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("exampledb/neostore");
        LegacyStore legacyStore = new LegacyStore(legacyStoreResource.getFile());
        LegacyPropertyIndexStoreReader propertyIndexStoreReader = legacyStore.getPropertyIndexStoreReader();
        int recordCount = 0;
        for (PropertyIndexRecord record : propertyIndexStoreReader.readPropertyIndexStore()) {
            ++recordCount;
        }
        Assert.assertEquals((long)12L, (long)recordCount);
    }

    @Test
    public void shouldReadRelationshipTypeRecords() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("exampledb/neostore");
        LegacyStore legacyStore = new LegacyStore(legacyStoreResource.getFile());
        LegacyRelationshipTypeStoreReader relationshipTypeStoreReader = legacyStore.getRelationshipTypeStoreReader();
        int recordCount = 0;
        for (RelationshipTypeRecord record : relationshipTypeStoreReader.readRelationshipTypes()) {
            ++recordCount;
        }
        Assert.assertEquals((long)1000L, (long)recordCount);
    }
}

