/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Jotm;
import org.objectweb.jotm.TransactionResourceManager;

public class JOTMTransactionManager
extends AbstractTransactionManager {
    public static final String NAME = "JOTM";
    private final TransactionManager current;
    private final Jotm jotm;
    private final XaDataSourceManager xaDataSourceManager;

    private JOTMTransactionManager(XaDataSourceManager xaDataSourceManager) {
        this.xaDataSourceManager = xaDataSourceManager;
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(1099);
        }
        catch (RemoteException re) {
            // empty catch block
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.createRegistry(1099);
            }
            catch (RemoteException re) {
                throw new Error(re);
            }
        }
        try {
            this.jotm = new Jotm(true, false);
            this.current = this.jotm.getTransactionManager();
        }
        catch (NamingException ne) {
            throw new Error("Error during JOTM creation", ne);
        }
    }

    public void init() {
        TransactionResourceManager trm = new TransactionResourceManager(){

            public void returnXAResource(String rmName, XAResource rmXares) {
            }
        };
        try {
            for (XaDataSource xaDs : this.xaDataSourceManager.getAllRegisteredDataSources()) {
                Current.getTransactionRecovery().registerResourceManager(xaDs.getName(), xaDs.getXaConnection().getXaResource(), xaDs.getName(), trm);
            }
            Current.getTransactionRecovery().startResourceManagerRecovery();
        }
        catch (XAException e) {
            throw new Error("Error registering xa datasource", e);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.current.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.current.commit();
    }

    public int getStatus() throws SystemException {
        return this.current.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        if (this.current == null) {
            return null;
        }
        return this.current.getTransaction();
    }

    public void resume(Transaction arg0) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.current.resume(arg0);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.current.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.current.setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
        this.current.setTransactionTimeout(arg0);
    }

    public Transaction suspend() throws SystemException {
        return this.current.suspend();
    }

    public void start() throws Throwable {
    }

    public void stop() {
        this.jotm.stop();
    }

    public void shutdown() throws Throwable {
    }

    public Jotm getJotmTxManager() {
        return this.jotm;
    }

    public static class Provider
    extends TransactionManagerProvider {
        public Provider() {
            super(JOTMTransactionManager.NAME);
        }

        public AbstractTransactionManager loadTransactionManager(String txLogDir, XaDataSourceManager xaDataSourceManager, KernelPanicEventGenerator kpe, TxHook rollbackHook, StringLogger msgLog, FileSystemAbstraction fileSystem) {
            return new JOTMTransactionManager(xaDataSourceManager);
        }
    }
}

