/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Random;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.RagManager;

public class TestDeadlockDetection {
    private static final Error DONE = new Error(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadlockDetection() {
        ResourceObject r1 = new ResourceObject("R1");
        ResourceObject r2 = new ResourceObject("R2");
        ResourceObject r3 = new ResourceObject("R3");
        ResourceObject r4 = new ResourceObject("R4");
        LockManager lm = new LockManager(new RagManager((TransactionManager)new PlaceboTm()));
        HelperThread t1 = new HelperThread("T1", lm);
        HelperThread t2 = new HelperThread("T2", lm);
        HelperThread t3 = new HelperThread("T3", lm);
        HelperThread t4 = new HelperThread("T4", lm);
        try {
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getReadLock(r4);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r2);
            t2.waitForCompletionOfTask();
            t2.getReadLock(r3);
            t2.waitForCompletionOfTask();
            t3.getReadLock(r3);
            t3.waitForCompletionOfTask();
            t3.getWriteLock(r1);
            t3.waitForWaitingState();
            t2.getWriteLock(r4);
            t2.waitForWaitingState();
            t1.getWriteLock(r2);
            t1.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t1.isLastGetLockDeadLock());
            t1.releaseReadLock(r4);
            t2.waitForCompletionOfTask();
            t1.getWriteLock(r2);
            t2.releaseReadLock(r2);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            t1.waitForWaitingState();
            t2.getWriteLock(r2);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t2.getReadLock(r4);
            t2.waitForCompletionOfTask();
            t1.releaseWriteLock(r2);
            t1.waitForCompletionOfTask();
            t1.getReadLock(r2);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t3.getReadLock(r2);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            t3.getWriteLock(r1);
            t4.getReadLock(r2);
            t4.waitForCompletionOfTask();
            t2.getWriteLock(r2);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r4);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            t3.releaseReadLock(r2);
            t3.waitForCompletionOfTask();
            t3.getWriteLock(r1);
            t2.releaseReadLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t3.waitForCompletionOfTask();
            t1.releaseReadLock(r2);
            t4.releaseReadLock(r2);
            t2.releaseReadLock(r3);
            t3.releaseReadLock(r3);
            t1.waitForCompletionOfTask();
            t2.waitForCompletionOfTask();
            t3.waitForCompletionOfTask();
            t4.waitForCompletionOfTask();
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r1);
            t2.waitForCompletionOfTask();
            t1.getWriteLock(r1);
            t1.waitForWaitingState();
            t2.getWriteLock(r1);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r1);
            t1.waitForCompletionOfTask();
        }
        finally {
            t1.quit();
            t2.quit();
            t3.quit();
            t4.quit();
        }
    }

    private void waitForWaitingThreadState(HelperThread ... threads) {
        for (HelperThread thread : threads) {
            thread.waitForWaitingState();
        }
    }

    @Test
    public void testStressMultipleThreads() {
        int i;
        for (int i2 = 0; i2 < StressThread.resources.length; ++i2) {
            StressThread.resources[i2] = new ResourceObject("RX" + i2);
        }
        Thread[] stressThreads = new Thread[50];
        StressThread.go = false;
        LockManager lm = new LockManager(new RagManager((TransactionManager)new PlaceboTm()));
        for (i = 0; i < stressThreads.length; ++i) {
            stressThreads[i] = new StressThread("T" + i, 100, 10, 0.8f, lm);
        }
        for (i = 0; i < stressThreads.length; ++i) {
            stressThreads[i].start();
        }
        StressThread.go = true;
    }

    public static class StressThread
    extends Thread {
        private static Random rand = new Random(System.currentTimeMillis());
        private static final Object READ = new Object();
        private static final Object WRITE = new Object();
        private static ResourceObject[] resources = new ResourceObject[10];
        private static boolean go = false;
        private String name;
        private int numberOfIterations;
        private int depthCount;
        private float readWriteRatio;
        private final LockManager lm;

        StressThread(String name, int numberOfIterations, int depthCount, float readWriteRatio, LockManager lm) {
            this.name = name;
            this.numberOfIterations = numberOfIterations;
            this.depthCount = depthCount;
            this.readWriteRatio = readWriteRatio;
            this.lm = lm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!go) {
                    HelperThread.sleep();
                }
                Stack<Object> lockStack = new Stack<Object>();
                Stack<ResourceObject> resourceStack = new Stack<ResourceObject>();
                try {
                    for (int i = 0; i < this.numberOfIterations; ++i) {
                        int depth = this.depthCount;
                        do {
                            float f = rand.nextFloat();
                            int n = rand.nextInt(resources.length);
                            if (f < this.readWriteRatio) {
                                this.lm.getReadLock((Object)resources[n]);
                                lockStack.push(READ);
                            } else {
                                this.lm.getWriteLock((Object)resources[n]);
                                lockStack.push(WRITE);
                            }
                            resourceStack.push(resources[n]);
                        } while (--depth > 0);
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == READ) {
                                this.lm.releaseReadLock(resourceStack.pop(), null);
                                continue;
                            }
                            this.lm.releaseWriteLock(resourceStack.pop(), null);
                        }
                    }
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == READ) {
                            this.lm.releaseReadLock(resourceStack.pop(), null);
                            continue;
                        }
                        this.lm.releaseWriteLock(resourceStack.pop(), null);
                    }
                }
                finally {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == READ) {
                            this.lm.releaseReadLock(resourceStack.pop(), null);
                            continue;
                        }
                        this.lm.releaseWriteLock(resourceStack.pop(), null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class ResourceObject {
        private String name = null;

        ResourceObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class HelperThread
    extends Thread {
        private final AtomicReference<ResourceTask> current = new AtomicReference<ResourceTask>(ResourceTask.IDLE);
        private volatile boolean deadlockOnLastWait = false;
        private final LockManager lm;

        HelperThread(String name, LockManager lm) {
            super(name);
            this.lm = lm;
        }

        private void assign(Task task, Object resource) {
            while (!this.current.compareAndSet(ResourceTask.IDLE, new ResourceTask(resource, task))) {
                if (this.current.get().resource == null) continue;
                throw new RuntimeException("Previous task not completed");
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.current.getAndSet(ResourceTask.BUSY).execute(this);
                    this.current.compareAndSet(ResourceTask.BUSY, ResourceTask.IDLE);
                }
            }
            catch (Error e) {
                if (e != DONE) {
                    throw e;
                }
                return;
            }
        }

        synchronized void waitForCompletionOfTask() {
            while (this.current.get() != ResourceTask.IDLE) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void waitForWaitingState() {
            while (this.getState() != Thread.State.WAITING || this.current.get().resource == ResourceTask.IDLE) {
                HelperThread.sleep();
            }
        }

        boolean isLastGetLockDeadLock() {
            return this.deadlockOnLastWait;
        }

        synchronized void getWriteLock(Object resource) {
            this.assign(Task.GET_WRITE_LOCK, resource);
        }

        synchronized void getReadLock(Object resource) {
            this.assign(Task.GET_READ_LOCK, resource);
        }

        synchronized void releaseWriteLock(Object resource) {
            this.assign(Task.RELEASE_WRITE_LOCK, resource);
        }

        synchronized void releaseReadLock(Object resource) {
            this.assign(Task.RELEASE_READ_LOCK, resource);
        }

        void quit() {
            while (!this.current.compareAndSet(ResourceTask.IDLE, ResourceTask.QUIT)) {
                HelperThread.sleep();
            }
        }

        static void sleep() {
            try {
                HelperThread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private static class ResourceTask {
        public static final ResourceTask IDLE = new ResourceTask(null, null){

            @Override
            void execute(HelperThread thread) {
                thread.current.set(this);
                HelperThread.sleep();
            }

            @Override
            public String toString() {
                return "IDLE";
            }
        };
        public static final ResourceTask BUSY = new ResourceTask(null, null);
        public static final ResourceTask QUIT = new ResourceTask(null, Task.QUIT);
        private final Object resource;
        private final Task task;

        ResourceTask(Object resource, Task task) {
            this.resource = resource;
            this.task = task;
        }

        void execute(HelperThread thread) {
            try {
                this.task.execute(thread.lm, this.resource);
                thread.deadlockOnLastWait = false;
            }
            catch (DeadlockDetectedException dde) {
                thread.deadlockOnLastWait = true;
            }
        }

        public String toString() {
            return this.task == null ? "BUSY" : this.task.toString();
        }
    }

    private static enum Task {
        GET_WRITE_LOCK{

            @Override
            void execute(LockManager lm, Object resource) {
                lm.getWriteLock(resource);
            }
        }
        ,
        GET_READ_LOCK{

            @Override
            void execute(LockManager lm, Object resource) {
                lm.getReadLock(resource);
            }
        }
        ,
        RELEASE_WRITE_LOCK{

            @Override
            void execute(LockManager lm, Object resource) {
                lm.releaseWriteLock(resource, null);
            }
        }
        ,
        RELEASE_READ_LOCK{

            @Override
            void execute(LockManager lm, Object resource) {
                lm.releaseReadLock(resource, null);
            }
        }
        ,
        QUIT{

            @Override
            void execute(LockManager lm, Object resource) {
                throw DONE;
            }
        };


        abstract void execute(LockManager var1, Object var2);
    }
}

