/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.util.DumpLogicalLog;

public class LogMatchers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogEntry> logEntries(String logPath) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(logPath, "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        try {
            LogEntry entry;
            LogIoUtils.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (boolean)true);
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            DumpLogicalLog.CommandFactory cmdFactory = new DumpLogicalLog.CommandFactory();
            while ((entry = LogIoUtils.readEntry((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (XaCommandFactory)cmdFactory)) != null) {
                entries.add(entry);
            }
            ArrayList<LogEntry> arrayList = entries;
            return arrayList;
        }
        finally {
            fileChannel.close();
        }
    }

    public static Iterable<LogEntry> logEntries(File file) throws IOException {
        return LogMatchers.logEntries(file.getAbsolutePath());
    }

    public static Matcher<Iterable<LogEntry>> containsExactly(final Matcher<? extends LogEntry> ... matchers) {
        return new TypeSafeMatcher<Iterable<LogEntry>>(){

            public boolean matchesSafely(Iterable<LogEntry> item) {
                Iterator<LogEntry> actualEntries = item.iterator();
                for (Matcher matcher : matchers) {
                    if (actualEntries.hasNext()) {
                        LogEntry next = actualEntries.next();
                        if (matcher.matches((Object)next)) continue;
                        return false;
                    }
                    return false;
                }
                return !actualEntries.hasNext();
            }

            public void describeTo(Description description) {
                for (Matcher matcher : matchers) {
                    description.appendDescriptionOf((SelfDescribing)matcher).appendText(",\n");
                }
            }
        };
    }

    public static Matcher<? extends LogEntry> startEntry(final Integer identifier, final int masterId, final int localId) {
        return new TypeSafeMatcher<LogEntry.Start>(){

            public boolean matchesSafely(LogEntry.Start entry) {
                return entry != null && entry.getIdentifier() == identifier.intValue() && entry.getMasterId() == masterId && entry.getLocalId() == localId;
            }

            public void describeTo(Description description) {
                description.appendText("Start[" + identifier + ",xid=<Any Xid>,master=" + masterId + ",me=" + localId + ",time=<Any Date>]");
            }
        };
    }

    public static Matcher<? extends LogEntry> onePhaseCommitEntry(final int identifier, final int txId) {
        return new TypeSafeMatcher<LogEntry.OnePhaseCommit>(){

            public boolean matchesSafely(LogEntry.OnePhaseCommit onePC) {
                return onePC != null && onePC.getIdentifier() == identifier && onePC.getTxId() == (long)txId;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("1PC[%d, txId=%d, <Any Date>],", identifier, txId));
            }
        };
    }

    public static Matcher<? extends LogEntry> doneEntry(final int identifier) {
        return new TypeSafeMatcher<LogEntry.Done>(){

            public boolean matchesSafely(LogEntry.Done done) {
                return done != null && done.getIdentifier() == identifier;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Done[%d]", identifier));
            }
        };
    }
}

