/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;

public class TestApplyTransactions {
    @Test
    public void testCommittedTransactionReceivedAreForcedToLog() throws Exception {
        File baseStoreDir = TargetDirectory.forTest(TestApplyTransactions.class).directory("testCommittedTransactionReceivedAreForcedToLog", true);
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), TestApplyTransactions.class.getName(), baseStoreDir.getAbsolutePath()});
        int exit = new ProcessStreamHandler(process, false).waitForResult();
        Assert.assertEquals((long)0L, (long)exit);
        File destStoreDir = new File(baseStoreDir, "destination");
        EmbeddedGraphDatabase dest = new EmbeddedGraphDatabase(destStoreDir.getAbsolutePath());
        XaDataSource destNeoDataSource = dest.getXaDataSourceManager().getXaDataSource("nioneodb");
        int latestTxId = (int)destNeoDataSource.getLastCommittedTxId();
        InMemoryLogBuffer theTx = new InMemoryLogBuffer();
        long extractedTxId = destNeoDataSource.getLogExtractor((long)latestTxId, (long)latestTxId).extractNext((LogBuffer)theTx);
        Assert.assertEquals((long)latestTxId, (long)extractedTxId);
    }

    public static void main(String[] args) throws Exception {
        File baseStoreDir = new File(args[0]);
        File originStoreDir = new File(baseStoreDir, "origin");
        File destStoreDir = new File(baseStoreDir, "destination");
        EmbeddedGraphDatabase origin = new EmbeddedGraphDatabase(originStoreDir.getAbsolutePath());
        Transaction tx = origin.beginTx();
        origin.createNode();
        tx.success();
        tx.finish();
        XaDataSource originNeoDataSource = origin.getXaDataSourceManager().getXaDataSource("nioneodb");
        int latestTxId = (int)originNeoDataSource.getLastCommittedTxId();
        System.out.println("Xtracted tx id " + latestTxId);
        InMemoryLogBuffer theTx = new InMemoryLogBuffer();
        originNeoDataSource.getLogExtractor((long)latestTxId, (long)latestTxId).extractNext((LogBuffer)theTx);
        EmbeddedGraphDatabase dest = new EmbeddedGraphDatabase(destStoreDir.getAbsolutePath());
        XaDataSource destNeoDataSource = dest.getXaDataSourceManager().getXaDataSource("nioneodb");
        destNeoDataSource.applyCommittedTransaction((long)latestTxId, (ReadableByteChannel)theTx);
        origin.shutdown();
    }
}

