/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class TestDirectMappedLogBuffer {
    @Test
    public void shouldHandleDiskThatWritesOnlyTwoBytesAtATime() throws Exception {
        FileChannelWithChoppyDisk mockChannel = new FileChannelWithChoppyDisk(2);
        DirectMappedLogBuffer writeBuffer = new DirectMappedLogBuffer((FileChannel)mockChannel);
        writeBuffer.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        writeBuffer.writeOut();
        Assert.assertThat((Object)mockChannel.buff.position(), (Matcher)Is.is((Object)16));
    }

    @Test(expected=IOException.class)
    public void shouldFailIfUnableToWriteASingleByte() throws Exception {
        FileChannelWithChoppyDisk mockChannel = new FileChannelWithChoppyDisk(0);
        DirectMappedLogBuffer writeBuffer = new DirectMappedLogBuffer((FileChannel)mockChannel);
        writeBuffer.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        writeBuffer.writeOut();
    }

    class FileChannelWithChoppyDisk
    extends FileChannel {
        ByteBuffer buff = ByteBuffer.allocate(1024);
        private int chunkSize;

        public FileChannelWithChoppyDisk(int writeThisMuchAtATime) {
            this.chunkSize = writeThisMuchAtATime;
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            return 0;
        }

        @Override
        public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
            return 0L;
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public int write(ByteBuffer byteBuffer, long l) throws IOException {
            int bytesToWrite = this.chunkSize > byteBuffer.limit() - byteBuffer.position() ? byteBuffer.limit() - byteBuffer.position() : this.chunkSize;
            this.buff.position((int)l);
            int originalLimit = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + bytesToWrite);
            this.buff.put(byteBuffer);
            byteBuffer.limit(originalLimit);
            return bytesToWrite;
        }

        @Override
        public long position() throws IOException {
            return this.buff.position();
        }

        @Override
        public FileChannel position(long l) throws IOException {
            this.buff.position((int)l);
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.buff.capacity();
        }

        @Override
        public FileChannel truncate(long l) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public void force(boolean b) throws IOException {
        }

        @Override
        public long transferTo(long l, long l1, WritableByteChannel writableByteChannel) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l1) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public int read(ByteBuffer byteBuffer, long l) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l1) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public FileLock lock(long l, long l1, boolean b) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public FileLock tryLock(long l, long l1, boolean b) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        protected void implCloseChannel() throws IOException {
            throw new NotImplementedException();
        }
    }
}

