/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.test.TargetDirectory;

public class TestLogPruneStrategy {
    private static final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();

    @Test
    public void noPruning() throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.NO_PRUNING);
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            this.assertLogsRangeExists(log, 0L, log.getHighestLogVersion() - 1L);
        }
        Assert.assertEquals((long)100L, (long)log.getHighestLogVersion());
    }

    @Test
    public void pruneByFileCountWhereAllContainsFilesTransactions() throws Exception {
        int fileCount = 5;
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)FS, (int)fileCount));
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            long from = Math.max(0L, log.getHighestLogVersion() - (long)fileCount);
            this.assertLogsRangeExists(log, from, log.getHighestLogVersion() - 1L);
        }
    }

    @Test
    public void pruneByFileCountWhereSomeAreEmpty() throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)FS, (int)3));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 0L);
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 1L, this.empty(1L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 2L, this.empty(1L, 2L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 3L, this.empty(1L, 2L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 4L, this.empty(1L, 2L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 5L, this.empty(1L, 2L, 5L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 3L, 6L, this.empty(5L));
    }

    @Test
    public void pruneByFileSize() throws Exception {
        int maxSize = 5000;
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.totalFileSize((FileSystemAbstraction)FS, (int)maxSize));
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            junit.framework.Assert.assertTrue((log.getTotalSizeOfAllExistingLogFiles() < maxSize + 1000 ? 1 : 0) != 0);
        }
    }

    @Test
    public void pruneByTransactionCount() throws Exception {
        MockedLogLoader log = new MockedLogLoader(10000, LogPruneStrategies.transactionCount((FileSystemAbstraction)FS, (int)1000));
        for (int i = 1; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            int avg = (int)(log.getLastCommittedTxId() / (long)i);
            junit.framework.Assert.assertTrue((log.getTotalTransactionCountOfAllExistingLogFiles() < avg * (i + 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void pruneByTransactionTimeSpan() throws Exception {
        int seconds = 2;
        int millisToKeep = (int)(TimeUnit.SECONDS.toMillis(seconds) / 10L);
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.transactionTimeSpan((FileSystemAbstraction)FS, (int)millisToKeep, (TimeUnit)TimeUnit.MILLISECONDS));
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(seconds);
        long lastTimestamp = System.currentTimeMillis();
        while (true) {
            if (!log.addTransaction(15, lastTimestamp = System.currentTimeMillis())) {
                continue;
            }
            this.assertLogRangeByTimestampExists(log, millisToKeep, lastTimestamp);
            if (System.currentTimeMillis() > end) break;
        }
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroFilesIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroSpaceIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.totalFileSize((FileSystemAbstraction)FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroTransactionsIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.transactionCount((FileSystemAbstraction)FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroTimeIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.transactionTimeSpan((FileSystemAbstraction)FS, (int)0, (TimeUnit)TimeUnit.SECONDS)));
    }

    private void makeSureOneLogStaysEvenWhenZeroConfigured(MockedLogLoader mockedLogLoader) throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)FS, (int)0));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 0L, this.empty(0L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 1L, this.empty(0L, 1L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 2L, 2L, this.empty(new long[0]));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 3L, 3L, this.empty(new long[0]));
    }

    private void assertLogRangeByTimestampExists(MockedLogLoader log, int millisToKeep, long lastTimestamp) {
        Long firstTimestamp;
        long lowerLimit = lastTimestamp - (long)millisToKeep;
        for (long version = log.getHighestLogVersion() - 1L; version >= 0L && (firstTimestamp = log.getFirstStartRecordTimestamp(version + 1L)) != null; --version) {
            junit.framework.Assert.assertTrue((String)("Log " + version + " should've been deleted by now. first of " + (version + 1L) + ":" + firstTimestamp + ", highestVersion:" + log.getHighestLogVersion() + ", lowerLimit:" + lowerLimit + ", timestamp:" + lastTimestamp), (firstTimestamp >= lowerLimit ? 1 : 0) != 0);
        }
    }

    private void assertLogsRangeExists(MockedLogLoader log, long from, long to) {
        this.assertLogsRangeExists(log, from, to, this.empty(new long[0]));
    }

    private void assertLogsRangeExists(MockedLogLoader log, long from, long to, Set<Long> empty) {
        long i;
        junit.framework.Assert.assertTrue((log.getHighestLogVersion() >= to ? 1 : 0) != 0);
        for (i = 0L; i < from; ++i) {
            junit.framework.Assert.assertFalse((String)("Log v" + i + " shouldn't exist when highest version is " + log.getHighestLogVersion() + " and prune strategy " + log.pruning), (boolean)new File(log.getFileName(i)).exists());
        }
        for (i = from; i <= to; ++i) {
            File file = new File(log.getFileName(i));
            junit.framework.Assert.assertTrue((String)("Log v" + i + " should exist when highest version is " + log.getHighestLogVersion() + " and prune strategy " + log.pruning), (boolean)file.exists());
            if (empty.contains(i)) {
                Assert.assertEquals((String)("Log v" + i + " should be empty"), (long)16L, (long)file.length());
                empty.remove(i);
                continue;
            }
            junit.framework.Assert.assertTrue((String)("Log v" + i + " should be at least size " + log.getLogSize()), (file.length() >= (long)log.getLogSize() ? 1 : 0) != 0);
        }
        junit.framework.Assert.assertTrue((String)("Expected to find empty logs: " + empty), (boolean)empty.isEmpty());
    }

    private Set<Long> empty(long ... items) {
        HashSet<Long> result = new HashSet<Long>();
        for (long item : items) {
            result.add(item);
        }
        return result;
    }

    private static class TestXaCommand
    extends XaCommand {
        private final int totalSize;

        public TestXaCommand(int totalSize) {
            this.totalSize = totalSize;
        }

        public void execute() {
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.putInt(this.totalSize);
            buffer.put(new byte[this.totalSize - 4]);
        }
    }

    private static class MockedLogLoader
    implements LogExtractor.LogLoader {
        private static final int MAX_LOG_SIZE = 1000;
        private static final byte[] RESOURCE_XID = new byte[]{5, 6, 7, 8, 9};
        private long version;
        private long tx;
        private File baseFile;
        private ByteBuffer activeBuffer;
        private int identifier = 1;
        private final LogPruneStrategy pruning;
        private final Map<Long, Long> lastCommittedTxs = new HashMap<Long, Long>();
        private final Map<Long, Long> timestamps = new HashMap<Long, Long>();
        private final int logSize;

        MockedLogLoader(LogPruneStrategy pruning) {
            this(1000, pruning);
        }

        MockedLogLoader(int logSize, LogPruneStrategy pruning) {
            this.logSize = logSize;
            this.pruning = pruning;
            this.activeBuffer = ByteBuffer.allocate(logSize * 10);
            File directory = TargetDirectory.forTest(TestLogPruneStrategy.class).directory("logs", true);
            directory.mkdirs();
            this.baseFile = new File(directory, "log");
            this.clearAndWriteHeader();
        }

        public int getLogSize() {
            return this.logSize;
        }

        private void clearAndWriteHeader() {
            this.activeBuffer.clear();
            LogIoUtils.writeLogHeader((ByteBuffer)this.activeBuffer, (long)this.version, (long)this.tx);
            this.activeBuffer.limit(this.activeBuffer.capacity());
            this.activeBuffer.position(16);
        }

        public ReadableByteChannel getLogicalLogOrMyselfCommitted(long version, long position) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getHighestLogVersion() {
            return this.version;
        }

        public String getFileName(long version) {
            File file = new File(this.baseFile + ".v" + version);
            return file.getAbsolutePath();
        }

        public boolean addTransaction(int commandSize, long date) throws IOException {
            boolean rotate;
            InMemoryLogBuffer tempLogBuffer = new InMemoryLogBuffer();
            LogIoUtils.writeStart((LogBuffer)tempLogBuffer, (int)this.identifier, (Xid)new XidImpl(XidImpl.getNewGlobalId(), RESOURCE_XID), (int)-1, (int)-1, (long)date);
            LogIoUtils.writeCommand((LogBuffer)tempLogBuffer, (int)this.identifier, (XaCommand)new TestXaCommand(commandSize));
            LogIoUtils.writeCommit((boolean)false, (LogBuffer)tempLogBuffer, (int)this.identifier, (long)(++this.tx), (long)date);
            LogIoUtils.writeDone((LogBuffer)tempLogBuffer, (int)this.identifier);
            tempLogBuffer.read(this.activeBuffer);
            if (!this.timestamps.containsKey(this.version)) {
                this.timestamps.put(this.version, date);
            }
            boolean bl = rotate = this.activeBuffer.capacity() - this.activeBuffer.remaining() >= this.logSize;
            if (rotate) {
                this.rotate();
            }
            return rotate;
        }

        public void addTransactionsUntilRotationHappens() throws IOException {
            int size = 10;
            while (!this.addTransaction(size, System.currentTimeMillis())) {
                size = Math.max(10, (size + 7) % 100);
            }
            return;
        }

        public void rotate() throws IOException {
            this.lastCommittedTxs.put(this.version, this.tx);
            this.writeBufferToFile(this.activeBuffer, this.getFileName(this.version++));
            this.pruning.prune((LogExtractor.LogLoader)this);
            this.clearAndWriteHeader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBufferToFile(ByteBuffer buffer, String fileName) throws IOException {
            AbstractInterruptibleChannel channel = null;
            try {
                buffer.flip();
                channel = new RandomAccessFile(fileName, "rw").getChannel();
                ((FileChannel)channel).write(buffer);
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }

        public int getTotalSizeOfAllExistingLogFiles() {
            File file;
            int size = 0;
            for (long version = this.getHighestLogVersion() - 1L; version >= 0L && (file = new File(this.getFileName(version))).exists(); --version) {
                size = (int)((long)size + file.length());
            }
            return size;
        }

        public int getTotalTransactionCountOfAllExistingLogFiles() {
            long upper;
            File file;
            long lower;
            if (this.getHighestLogVersion() == 0L) {
                return 0;
            }
            for (lower = upper = this.getHighestLogVersion() - 1L; lower >= 0L && (file = new File(this.getFileName(lower - 1L))).exists(); --lower) {
            }
            return (int)(this.getLastCommittedTxId() - this.getFirstCommittedTxId(lower));
        }

        public Long getFirstCommittedTxId(long version) {
            return this.lastCommittedTxs.get(version);
        }

        public Long getFirstStartRecordTimestamp(long version) {
            return this.timestamps.get(version);
        }

        public long getLastCommittedTxId() {
            return this.tx;
        }
    }
}

