/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.xa.CommandMatchers;
import org.neo4j.kernel.impl.transaction.xaframework.DirectLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.LogMatchers;
import org.neo4j.kernel.impl.transaction.xaframework.PartialTransactionCopier;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.DumpLogicalLog;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.TargetDirectory;

public class TestPartialTransactionCopier {
    public static final String NEW_LOG_FILENAME = "new.log";
    TargetDirectory targetDir = TargetDirectory.forTest(this.getClass());
    @Rule
    public TargetDirectory.TestDirectory testDir = this.targetDir.cleanTestDirectory();

    @Test
    public void temp() throws Exception {
        int masterId = -1;
        int meId = -1;
        File newLogFile = new File(this.testDir.directory(), NEW_LOG_FILENAME);
        Pair<File, Integer> broken = this.createBrokenLogFile();
        File brokenLogFile = (File)broken.first();
        Integer brokenTxIdentifier = (Integer)broken.other();
        FileChannel brokenLog = new RandomAccessFile(brokenLogFile, "rw").getChannel();
        LogIoUtils.readLogHeader((ByteBuffer)ByteBuffer.allocate(713), (ReadableByteChannel)brokenLog, (boolean)true);
        PartialTransactionCopier copier = new PartialTransactionCopier(ByteBuffer.allocate(713), (XaCommandFactory)new DumpLogicalLog.CommandFactory(), StringLogger.DEV_NULL, new LogExtractor.LogPositionCache(), null, this.createXidMapWithOneStartEntry(masterId, brokenTxIdentifier));
        copier.copy(brokenLog, this.createNewLogWithHeader(newLogFile), 1L);
        Assert.assertThat(LogMatchers.logEntries(newLogFile), LogMatchers.containsExactly(LogMatchers.startEntry(brokenTxIdentifier, masterId, meId), CommandMatchers.nodeCommandEntry(brokenTxIdentifier, 2), LogMatchers.onePhaseCommitEntry(brokenTxIdentifier, brokenTxIdentifier), LogMatchers.startEntry(4, masterId, meId), CommandMatchers.nodeCommandEntry(4, 3), LogMatchers.onePhaseCommitEntry(4, 4), LogMatchers.doneEntry(4), LogMatchers.startEntry(5, masterId, meId), CommandMatchers.nodeCommandEntry(5, 4), LogMatchers.onePhaseCommitEntry(5, 5), LogMatchers.doneEntry(5)));
    }

    private ArrayMap<Integer, LogEntry.Start> createXidMapWithOneStartEntry(int masterId, Integer brokenTxId) {
        ArrayMap xidentMap = new ArrayMap();
        xidentMap.put((Object)brokenTxId, (Object)new LogEntry.Start(null, brokenTxId.intValue(), masterId, 3, 4L, 5L));
        return xidentMap;
    }

    private LogBuffer createNewLogWithHeader(File newLogFile) throws IOException {
        FileChannel newLog = new RandomAccessFile(new File(this.testDir.directory(), NEW_LOG_FILENAME), "rw").getChannel();
        DirectLogBuffer newLogBuffer = new DirectLogBuffer(newLog, ByteBuffer.allocate(10000));
        ByteBuffer buf = ByteBuffer.allocate(100);
        LogIoUtils.writeLogHeader((ByteBuffer)buf, (long)1L, (long)4L);
        newLogBuffer.getFileChannel().write(buf);
        return newLogBuffer;
    }

    private Pair<File, Integer> createBrokenLogFile() throws Exception {
        String storeDir = this.testDir.directory().getAbsolutePath();
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        this.runSmallWriteTransaction(db);
        this.runSmallWriteTransaction(db);
        this.runSmallWriteTransaction(db);
        this.runSmallWriteTransaction(db);
        db.shutdown();
        EverythingButDoneRecordFilter filter = new EverythingButDoneRecordFilter();
        File logFile = LogTestUtils.filterNeostoreLogicalLog(new File(storeDir, "nioneo_logical.log.v0"), (LogTestUtils.LogHook<LogEntry>)filter);
        return Pair.of((Object)logFile, (Object)filter.brokenTxIdentifier);
    }

    private void runSmallWriteTransaction(GraphDatabaseAPI db) {
        Transaction tx2 = db.beginTx();
        db.createNode();
        tx2.success();
        tx2.finish();
    }

    public class EverythingButDoneRecordFilter
    implements LogTestUtils.LogHook<LogEntry> {
        int doneRecordCount = 0;
        public Integer brokenTxIdentifier = null;

        public boolean accept(LogEntry item) {
            if (item instanceof LogEntry.Done) {
                ++this.doneRecordCount;
                if (this.doneRecordCount == 2) {
                    this.brokenTxIdentifier = item.getIdentifier();
                    return false;
                }
            }
            return true;
        }

        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    }
}

