/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.Random;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.RollbackUnclean;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;

public class TestTxEntries {
    private final Random random = new Random();
    private final long refTime = System.currentTimeMillis();
    private final int refId = 1;
    private final int refMaster = 1;
    private final int refMe = 1;
    private final long startPosition = 1000L;

    @Test
    public void testStartEntryWrittenOnceOnRollback() throws Exception {
        String storeDir = TargetDirectory.forTest(TestTxEntries.class).directory("rollBack", true).getAbsolutePath();
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), RollbackUnclean.class.getName(), storeDir});
        int exit = new ProcessStreamHandler(process, true).waitForResult();
        Assert.assertEquals((long)0L, (long)exit);
        new GraphDatabaseFactory().newEmbeddedDatabase(storeDir).shutdown();
    }

    @Test
    public void startEntryShouldBeUniqueIfEitherValueChanges() throws Exception {
        this.assertorrectChecksumEquality(this.randomXid(Boolean.TRUE));
        this.assertorrectChecksumEquality(this.randomXid(Boolean.FALSE));
    }

    private void assertorrectChecksumEquality(Xid refXid) {
        LogEntry.Start ref = new LogEntry.Start(refXid, 1, 1, 1, 1000L, this.refTime);
        this.assertChecksumsEquals(ref, new LogEntry.Start(refXid, 1, 1, 1, 1000L, this.refTime));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(this.randomXid(null), 1, 1, 1, 1000L, this.refTime));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(refXid, 1, 2, 1, 1000L, this.refTime));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(refXid, 1, 1, 2, 1000L, this.refTime));
    }

    private void assertChecksumsNotEqual(LogEntry.Start ref, LogEntry.Start other) {
        Assert.assertFalse((ref.getChecksum() == other.getChecksum() ? 1 : 0) != 0);
    }

    private void assertChecksumsEquals(LogEntry.Start ref, LogEntry.Start other) {
        Assert.assertEquals((long)ref.getChecksum(), (long)other.getChecksum());
    }

    private Xid randomXid(Boolean trueForPositive) {
        XidImpl xid;
        do {
            xid = new XidImpl(this.randomBytes(), this.randomBytes());
        } while (trueForPositive != null && xid.hashCode() > 0 != trueForPositive);
        return xid;
    }

    private byte[] randomBytes() {
        byte[] bytes = new byte[this.random.nextInt(10) + 5];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.random.nextInt(255);
        }
        return bytes;
    }
}

