/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestUpgradeOneDotFourToFiveIT {
    private static final File PATH = new File("target/test-data/upgrade-1.4-5");

    @BeforeClass
    public static void doBefore() throws Exception {
        FileUtils.deleteRecursively((File)PATH);
    }

    @Test(expected=IllegalLogFormatException.class)
    public void cannotRecoverNoncleanShutdownDbWithOlderLogFormat() throws Exception {
        FileUtils.copyRecursively((File)new File(TestUpgradeOneDotFourToFiveIT.class.getResource("non-clean-1.4.2-db/neostore").getFile()).getParentFile(), (File)PATH);
        XaLogicalLog log = new XaLogicalLog(this.resourceFile(), null, null, null, CommonFactories.defaultLogBufferFactory(), CommonFactories.defaultFileSystemAbstraction(), StringLogger.DEV_NULL, LogPruneStrategies.NO_PRUNING);
        log.open();
        Assert.fail((String)"Shouldn't be able to start");
    }

    protected String resourceFile() {
        return new File(PATH, "nioneo_logical.log").getAbsolutePath();
    }
}

