/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class DepthZeroTraversalTest
extends AbstractTestBase {
    @Before
    public void createTheGraph() {
        DepthZeroTraversalTest.createGraph("0 ROOT 1", "1 KNOWS 2", "2 KNOWS 3", "2 KNOWS 4", "4 KNOWS 5", "5 KNOWS 6", "3 KNOWS 1");
    }

    @Test
    public void shouldGetStartNodeOnDepthZero() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.atDepth((int)0));
        DepthZeroTraversalTest.expectNodes(description.traverse(DepthZeroTraversalTest.getNodeWithName("6")), "6");
    }

    @Test
    public void shouldGetCorrectNodesAtDepthOne() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.fromDepth((int)1)).evaluator(Evaluators.toDepth((int)1));
        DepthZeroTraversalTest.expectNodes(description.traverse(DepthZeroTraversalTest.getNodeWithName("6")), "5");
    }

    @Test
    public void shouldGetCorrectNodesAtDepthZero() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.fromDepth((int)0)).evaluator(Evaluators.toDepth((int)0));
        DepthZeroTraversalTest.expectNodes(description.traverse(DepthZeroTraversalTest.getNodeWithName("6")), "6");
    }
}

