/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestMultipleStartNodes
extends AbstractTestBase {
    @Test
    public void myFriendsAsWellAsYourFriends() throws Exception {
        TestMultipleStartNodes.createGraph("you KNOW me", "you KNOW f1", "you KNOW f4", "me KNOW f1", "me KNOW f4", "me KNOW f2", "me KNOW f3", "f1 KNOW f5", "f2 KNOW f6", "you KNOW f7", "f7 KNOW f8");
        DynamicRelationshipType KNOW = DynamicRelationshipType.withName((String)"KNOW");
        Node you = TestMultipleStartNodes.getNodeWithName("you");
        Node me = TestMultipleStartNodes.getNodeWithName("me");
        String[] levelOneFriends = new String[]{"f1", "f2", "f3", "f4", "f7"};
        TraversalDescription levelOneTraversal = Traversal.traversal().relationships((RelationshipType)KNOW).evaluator(Evaluators.atDepth((int)1));
        TestMultipleStartNodes.expectNodes(levelOneTraversal.depthFirst().traverse(new Node[]{you, me}), levelOneFriends);
        TestMultipleStartNodes.expectNodes(levelOneTraversal.breadthFirst().traverse(new Node[]{you, me}), levelOneFriends);
        String[] levelTwoFriends = new String[]{"f5", "f6", "f8"};
        TraversalDescription levelTwoTraversal = Traversal.traversal().relationships((RelationshipType)KNOW).evaluator(Evaluators.atDepth((int)2));
        TestMultipleStartNodes.expectNodes(levelTwoTraversal.depthFirst().traverse(new Node[]{you, me}), levelTwoFriends);
        TestMultipleStartNodes.expectNodes(levelTwoTraversal.breadthFirst().traverse(new Node[]{you, me}), levelTwoFriends);
    }
}

