/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.OrderedByTypeExpander;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestOrderByTypeExpander
extends AbstractTestBase {
    @Before
    public void setup() {
        TestOrderByTypeExpander.createGraph("A1 NEXT A2", "A2 NEXT A3", "A1 FIRST_COMMENT C1", "C1 COMMENT C2", "C2 COMMENT C3", "A2 FIRST_COMMENT C4", "C4 COMMENT C5", "C5 COMMENT C6", "A3 FIRST_COMMENT C7", "C7 COMMENT C8", "C8 COMMENT C9");
    }

    @Test
    public void makeSureNodesAreTraversedInCorrectOrder() {
        DynamicRelationshipType next = DynamicRelationshipType.withName((String)"NEXT");
        DynamicRelationshipType firstComment = DynamicRelationshipType.withName((String)"FIRST_COMMENT");
        DynamicRelationshipType comment = DynamicRelationshipType.withName((String)"COMMENT");
        StandardExpander expander = new OrderedByTypeExpander().add((RelationshipType)firstComment).add((RelationshipType)comment).add((RelationshipType)next);
        Iterator<Object> itr = Traversal.traversal().depthFirst().expand((RelationshipExpander)expander).traverse(TestOrderByTypeExpander.node("A1")).nodes().iterator();
        this.assertOrder(itr, "A1", "C1", "C2", "C3", "A2", "C4", "C5", "C6", "A3", "C7", "C8", "C9");
        expander = new OrderedByTypeExpander().add((RelationshipType)next).add((RelationshipType)firstComment).add((RelationshipType)comment);
        itr = Traversal.traversal().depthFirst().expand((RelationshipExpander)expander).traverse(TestOrderByTypeExpander.node("A1")).nodes().iterator();
        this.assertOrder(itr, "A1", "A2", "A3", "C7", "C8", "C9", "C4", "C5", "C6", "C1", "C2", "C3");
    }

    private void assertOrder(Iterator<Node> itr, String ... names) {
        for (String name : names) {
            Node node = itr.next();
            Assert.assertEquals((String)("expected " + name + ", was " + node.getProperty("name")), (Object)TestOrderByTypeExpander.getNodeWithName(name), (Object)node);
        }
        Assert.assertFalse((boolean)itr.hasNext());
    }
}

