/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.Sorting;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestSorting
extends AbstractTestBase {
    @Test
    public void sortFriendsByName() throws Exception {
        String me = "me";
        String abraham = "Abraham";
        String george = "George";
        String dan = "Dan";
        String zack = "Zack";
        String andreas = "Andreas";
        String nicholas = "Nicholas";
        String knows = "KNOWS";
        TestSorting.createGraph(TestSorting.triplet(me, knows, abraham), TestSorting.triplet(me, knows, george), TestSorting.triplet(george, knows, dan), TestSorting.triplet(me, knows, zack), TestSorting.triplet(zack, knows, andreas), TestSorting.triplet(george, knows, andreas), TestSorting.triplet(andreas, knows, nicholas));
        List<Node> nodes = this.asNodes(abraham, george, dan, zack, andreas, nicholas);
        Assert.assertEquals(nodes, (Object)IteratorUtil.asCollection((Iterable)Traversal.traversal().evaluator(Evaluators.excludeStartPosition()).sort(Sorting.endNodeProperty((String)"name")).traverse(TestSorting.getNodeWithName(me)).nodes()));
    }

    private List<Node> asNodes(String abraham, String george, String dan, String zack, String andreas, String nicholas) {
        ArrayList<String> allNames = new ArrayList<String>(Arrays.asList(abraham, george, dan, zack, andreas, nicholas));
        Collections.sort(allNames);
        ArrayList<Node> all = new ArrayList<Node>();
        for (String name : allNames) {
            all.add(TestSorting.getNodeWithName(name));
        }
        return all;
    }

    private static String triplet(String i, String type, String you) {
        return i + " " + type + " " + you;
    }
}

