/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

public class TestTraversal
extends AbstractNeo4jTestCase {
    @Test
    public void testSanityChecks1() throws Exception {
        Node root = this.getGraphDb().createNode();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        this.sanityCheckTraverser("Sanity check failed: null traversable rels should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, null, Direction.OUTGOING, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL);
        this.sanityCheckTraverser("Sanity check failed: null stop eval should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], Direction.OUTGOING, null, ReturnableEvaluator.ALL);
        this.sanityCheckTraverser("Sanity check failed: null returnable evaluator should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], Direction.OUTGOING, StopEvaluator.END_OF_GRAPH, null);
        root.delete();
    }

    @Test
    public void testSanityChecks2() throws Exception {
        Node root = this.getGraphDb().createNode();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        Direction[] traversableDirs = new Direction[]{Direction.OUTGOING};
        this.sanityCheckTraverser("Sanity check failed: null traversable rels should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, null, traversableDirs[0], StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL);
        this.sanityCheckTraverser("Sanity check failed: null traversable rels should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], null, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL);
        this.sanityCheckTraverser("Sanity check failed: null stop eval should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], traversableDirs[0], null, ReturnableEvaluator.ALL);
        this.sanityCheckTraverser("Sanity check failed: null returnable evaluator should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], traversableDirs[0], StopEvaluator.END_OF_GRAPH, null);
        this.sanityCheckTraverser("Sanity check failed: null returnable evaluator should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, traversableRels[0], null, StopEvaluator.END_OF_GRAPH, null);
        this.sanityCheckTraverser("Sanity check failed: null returnable evaluator should throw an IllegalArgumentException", Traverser.Order.BREADTH_FIRST, root, null, traversableDirs[0], StopEvaluator.END_OF_GRAPH, null);
        root.delete();
    }

    private void sanityCheckTraverser(String failMessage, Traverser.Order type, Node startNode, RelationshipType traversableRel, Direction direction, StopEvaluator stopEval, ReturnableEvaluator retEval) {
        try {
            startNode.traverse(type, stopEval, retEval, traversableRel, direction);
            Assert.fail((String)failMessage);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBruteBreadthTraversal() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL};
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH, traversableRels[1], Direction.BOTH);
        try {
            this.assertLevelsOfNodes(traverser, new String[][]{{"1"}, {"2", "3", "4"}, {"5", "6", "7", "8", "9"}, {"10", "11", "12", "13", "14"}});
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    private void assertNodes(Traverser traverser, String ... expectedNodes) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(expectedNodes));
        for (Node node : traverser) {
            Assert.assertTrue((boolean)set.remove(node.getProperty("node.test.id")));
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }

    private void assertLevelsOfNodes(Traverser traverser, String[][] nodes) {
        HashMap map = new HashMap();
        for (Node node : traverser) {
            ArrayList<String> collection = (ArrayList<String>)map.get(traverser.currentPosition().depth());
            if (collection == null) {
                collection = new ArrayList<String>();
                map.put(traverser.currentPosition().depth(), collection);
            }
            String name = (String)node.getProperty("node.test.id");
            collection.add(name);
        }
        for (int i = 0; i < nodes.length; ++i) {
            List<String> expected = Arrays.asList(nodes[i]);
            Assert.assertEquals(expected, map.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRelBreadthTraversal() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH);
        try {
            this.assertLevelsOfNodes(traverser, new String[][]{{"1"}, {"2", "3", "4"}, {"5", "6", "7"}, {"10", "11", "12", "13"}});
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectedBreadthTraversal() throws Exception {
        Node root = this.buildIseTreePopulation();
        Node startNode = null;
        try {
            ReturnableEvaluator returnEvaluator = new ReturnableEvaluator(){

                public boolean isReturnableNode(TraversalPosition pos) {
                    try {
                        Node node = pos.currentNode();
                        String key = "node.test.id";
                        String nodeId = (String)node.getProperty(key);
                        return nodeId.equals("2");
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            };
            Traverser toTheMiddleTraverser = root.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, returnEvaluator, (RelationshipType)MyRelTypes.TEST, Direction.BOTH);
            startNode = (Node)toTheMiddleTraverser.iterator().next();
            Assert.assertEquals((Object)"2", (Object)startNode.getProperty("node.test.id"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Something went wrong when trying to get a start node in the middle of the tree: " + e));
        }
        Traverser traverser = startNode.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, (RelationshipType)MyRelTypes.TEST, Direction.OUTGOING);
        try {
            this.assertNextNodeId(traverser, "2");
            this.assertNextNodeId(traverser, "5");
            this.assertNextNodeId(traverser, "6");
            this.assertNextNodeId(traverser, "10");
            this.assertNextNodeId(traverser, "11");
            this.assertNextNodeId(traverser, "12");
            this.assertNextNodeId(traverser, "13");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBruteDepthTraversal() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL};
        Traverser traverser = root.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH, traversableRels[1], Direction.BOTH);
        try {
            this.assertNodes(traverser, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRelDepthTraversal() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        Traverser traverser = root.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH);
        try {
            this.assertNodes(traverser, "1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnCurrentNode() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        StopEvaluator stopEvaluator = new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                try {
                    Node node = position.currentNode();
                    String nodeId = (String)node.getProperty("node.test.id");
                    return nodeId.equals("5") || nodeId.equals("6") || nodeId.equals("3") || nodeId.equals("4");
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, stopEvaluator, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH);
        try {
            this.assertNextNodeId(traverser, "1");
            this.assertNextNodeId(traverser, "2");
            this.assertNextNodeId(traverser, "3");
            this.assertNextNodeId(traverser, "4");
            this.assertNextNodeId(traverser, "5");
            this.assertNextNodeId(traverser, "6");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnPreviousNode() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        StopEvaluator stopEvaluator = new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                try {
                    Node node = position.previousNode();
                    String nodeId = (String)node.getProperty("node.test.id");
                    return nodeId.equals("1");
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, stopEvaluator, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH);
        try {
            this.assertNextNodeId(traverser, "1");
            this.assertNextNodeId(traverser, "2");
            this.assertNextNodeId(traverser, "3");
            this.assertNextNodeId(traverser, "4");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnDepth() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        StopEvaluator stopEvaluator = new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.depth() >= 2;
            }
        };
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, stopEvaluator, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH);
        try {
            this.assertNextNodeId(traverser, "1");
            this.assertNextNodeId(traverser, "2");
            this.assertNextNodeId(traverser, "3");
            this.assertNextNodeId(traverser, "4");
            this.assertNextNodeId(traverser, "5");
            this.assertNextNodeId(traverser, "6");
            this.assertNextNodeId(traverser, "7");
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnReturnedNodes() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST};
        StopEvaluator stopEvaluator = new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.returnedNodesCount() >= 5;
            }
        };
        ReturnableEvaluator returnEvaluator = new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                return position.returnedNodesCount() < 5;
            }
        };
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, stopEvaluator, returnEvaluator, traversableRels[0], Direction.BOTH);
        try {
            this.assertLevelsOfNodes(traverser, new String[][]{{"1"}, {"2", "3", "4"}, {"5"}});
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnLastRelationship() throws Exception {
        Node root = this.buildIseTreePopulation();
        RelationshipType[] traversableRels = new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL};
        StopEvaluator stopEvaluator = new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                Relationship rel = position.lastRelationshipTraversed();
                return rel != null && rel.isType((RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            }
        };
        Traverser traverser = root.traverse(Traverser.Order.BREADTH_FIRST, stopEvaluator, ReturnableEvaluator.ALL, traversableRels[0], Direction.BOTH, traversableRels[1], Direction.BOTH);
        try {
            this.assertLevelsOfNodes(traverser, new String[][]{{"1"}, {"2", "3", "4"}, {"5", "6", "7", "8", "9"}, {"10", "11", "12", "13"}});
            Assert.assertTrue((String)"Too many nodes returned from traversal", (!traverser.iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (NoSuchElementException nsee) {
            Assert.fail((String)"Too few nodes returned from traversal");
        }
        finally {
            this.deleteNodeTreeRecursively(root, 0);
        }
    }

    private Node buildIseTreePopulation() throws Exception {
        Node[] nodeSpace = new Node[]{null, this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode(), this.getGraphDb().createNode()};
        String key = "node.test.id";
        for (int i = 1; i < nodeSpace.length; ++i) {
            nodeSpace[i].setProperty(key, (Object)("" + i));
        }
        MyRelTypes ise = MyRelTypes.TEST;
        MyRelTypes clone = MyRelTypes.TEST_TRAVERSAL;
        nodeSpace[1].createRelationshipTo(nodeSpace[2], (RelationshipType)ise);
        nodeSpace[2].createRelationshipTo(nodeSpace[5], (RelationshipType)ise);
        nodeSpace[5].createRelationshipTo(nodeSpace[10], (RelationshipType)ise);
        nodeSpace[5].createRelationshipTo(nodeSpace[11], (RelationshipType)ise);
        nodeSpace[5].createRelationshipTo(nodeSpace[12], (RelationshipType)ise);
        nodeSpace[5].createRelationshipTo(nodeSpace[13], (RelationshipType)ise);
        nodeSpace[2].createRelationshipTo(nodeSpace[6], (RelationshipType)ise);
        nodeSpace[1].createRelationshipTo(nodeSpace[3], (RelationshipType)ise);
        nodeSpace[1].createRelationshipTo(nodeSpace[4], (RelationshipType)ise);
        nodeSpace[3].createRelationshipTo(nodeSpace[7], (RelationshipType)ise);
        nodeSpace[6].createRelationshipTo(nodeSpace[7], (RelationshipType)clone);
        nodeSpace[4].createRelationshipTo(nodeSpace[8], (RelationshipType)clone);
        nodeSpace[4].createRelationshipTo(nodeSpace[9], (RelationshipType)clone);
        nodeSpace[9].createRelationshipTo(nodeSpace[14], (RelationshipType)clone);
        return nodeSpace[1];
    }

    private void deleteNodeTreeRecursively(Node currentNode, int depth) {
        if (depth > 100) {
            throw new RuntimeException("Recursive guard: depth = " + depth);
        }
        if (currentNode == null) {
            return;
        }
        Iterable rels = currentNode.getRelationships();
        for (Relationship rel : rels) {
            if (!rel.getStartNode().equals(currentNode)) continue;
            Node endNode = rel.getEndNode();
            rel.delete();
            this.deleteNodeTreeRecursively(endNode, depth + 1);
        }
        String msg = "Deleting " + currentNode + "\t[";
        String id = (String)currentNode.getProperty("node.test.id");
        msg = msg + id + "]";
        Iterable allRels = currentNode.getRelationships();
        for (Relationship rel : allRels) {
            rel.delete();
        }
        currentNode.delete();
    }

    private void assertNextNodeId(Traverser traverser, String property) throws NotFoundException {
        Node node = (Node)traverser.iterator().next();
        Assert.assertEquals((Object)property, (Object)node.getProperty("node.test.id"));
    }
}

