/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestTraversalWithLoops
extends AbstractTestBase {
    @Test
    public void traverseThroughNodeWithLoop() throws Exception {
        TestTraversalWithLoops.createGraph("a TO b", "b TO c", "c TO c", "c TO d", "d TO d", "d TO e");
        Node a = TestTraversalWithLoops.getNodeWithName("a");
        final Node e = TestTraversalWithLoops.getNodeWithName("e");
        Evaluator onlyEndNode = new Evaluator(){

            public Evaluation evaluate(Path path) {
                return Evaluation.ofIncludes((boolean)path.endNode().equals(e));
            }
        };
        TraversalDescription basicTraverser = Traversal.traversal().evaluator(onlyEndNode);
        TestTraversalWithLoops.expectPaths(basicTraverser.traverse(a), "a,b,c,d,e");
        TestTraversalWithLoops.expectPaths(basicTraverser.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).traverse(a), "a,b,c,d,e", "a,b,c,c,d,e", "a,b,c,d,d,e", "a,b,c,c,d,d,e");
    }
}

