/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestUniqueness
extends AbstractTestBase {
    @Test
    public void nodeLevelUniqueness() throws Exception {
        TestUniqueness.createGraph("a TO b", "a TO c", "a TO d", "a TO e", "a TO e", "b TO e", "d TO e", "c TO b");
        DynamicRelationshipType to = DynamicRelationshipType.withName((String)"TO");
        Node a = TestUniqueness.getNodeWithName("a");
        Node e = TestUniqueness.getNodeWithName("e");
        Path[] paths = this.splitPathsOnePerLevel(Traversal.traversal().relationships((RelationshipType)to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.NODE_LEVEL).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{e})).traverse(a));
        AbstractTestBase.NodePathRepresentation pathRepresentation = new AbstractTestBase.NodePathRepresentation(NAME_PROPERTY_REPRESENTATION);
        Assert.assertEquals((Object)"a,e", (Object)pathRepresentation.represent(paths[1]));
        String levelTwoPathRepresentation = pathRepresentation.represent(paths[2]);
        Assert.assertTrue((levelTwoPathRepresentation.equals("a,b,e") || levelTwoPathRepresentation.equals("a,d,e") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"a,c,b,e", (Object)pathRepresentation.represent(paths[3]));
    }

    @Test
    public void nodeGlobalUniqueness() {
        TestUniqueness.createGraph("a TO b", "a TO c", "b TO c");
        DynamicRelationshipType to = DynamicRelationshipType.withName((String)"TO");
        Node a = TestUniqueness.getNodeWithName("a");
        Node c = TestUniqueness.getNodeWithName("c");
        Iterator path = Traversal.traversal().relationships((RelationshipType)to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{c})).traverse(a).iterator();
        Path thePath = (Path)path.next();
        Assert.assertFalse((boolean)path.hasNext());
        AbstractTestBase.NodePathRepresentation pathRepresentation = new AbstractTestBase.NodePathRepresentation(NAME_PROPERTY_REPRESENTATION);
        Assert.assertEquals((Object)"a,b,c", (Object)pathRepresentation.represent(thePath));
    }

    @Test
    public void relationshipLevelAndGlobalUniqueness() throws Exception {
        TestUniqueness.createGraph("a TO b", "b TO c", "a TO b", "b TO c", "a TO c", "a TO c", "c TO d");
        DynamicRelationshipType to = DynamicRelationshipType.withName((String)"TO");
        Node a = TestUniqueness.getNodeWithName("a");
        Node d = TestUniqueness.getNodeWithName("d");
        Iterator paths = Traversal.traversal().relationships((RelationshipType)to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.NONE).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{d})).traverse(a).iterator();
        int count = 0;
        while (paths.hasNext()) {
            ++count;
            paths.next();
        }
        Assert.assertEquals((String)"wrong number of paths calculated, the test assumption is wrong", (long)6L, (long)count);
        paths = Traversal.traversal().relationships((RelationshipType)to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_LEVEL).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{d})).traverse(a).iterator();
        count = 0;
        while (paths.hasNext()) {
            ++count;
            paths.next();
        }
        paths = Traversal.traversal().relationships((RelationshipType)to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{d})).traverse(a).iterator();
        count = 0;
        while (paths.hasNext()) {
            ++count;
            paths.next();
        }
        Assert.assertEquals((String)"wrong number of paths calculated with relationship global uniqueness", (long)1L, (long)count);
    }

    private Path[] splitPathsOnePerLevel(Traverser traverser) {
        Path[] paths = new Path[10];
        for (Path path : traverser) {
            int depth = path.length();
            if (paths[depth] != null) {
                Assert.fail((String)("More than one path one depth " + depth));
            }
            paths[depth] = path;
        }
        return paths;
    }
}

