/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TreeGraphTest
extends AbstractTestBase {
    private static final String[] THE_WORLD_AS_WE_KNOWS_IT = new String[]{"1 TO 2", "1 TO 3", "1 TO 4", "2 TO 5", "2 TO 6", "2 TO 7", "3 TO 8", "3 TO 9", "3 TO A", "4 TO B", "4 TO C", "4 TO D"};

    @Before
    public void setupGraph() {
        TreeGraphTest.createGraph(THE_WORLD_AS_WE_KNOWS_IT);
    }

    @Test
    public void nodesIteratorReturnAllNodes() throws Exception {
        Traverser traverser = Traversal.traversal().traverse(TreeGraphTest.node("1"));
        int count = 0;
        for (Node node : traverser.nodes()) {
            Assert.assertNotNull((String)("returned nodes should not be null. node #" + count), (Object)node);
            ++count;
        }
        Assert.assertEquals((long)13L, (long)count);
    }

    @Test
    public void relationshipsIteratorReturnAllNodes() throws Exception {
        Traverser traverser = Traversal.traversal().traverse(TreeGraphTest.node("1"));
        int count = 0;
        for (Relationship relationship : traverser.relationships()) {
            Assert.assertNotNull((String)("returned relationships should not be. relationship #" + count), (Object)relationship);
            ++count;
        }
        Assert.assertEquals((long)12L, (long)count);
    }

    @Test
    public void pathsIteratorReturnAllNodes() throws Exception {
        Traverser traverser = Traversal.traversal().traverse(TreeGraphTest.node("1"));
        int count = 0;
        for (Path path : traverser) {
            Assert.assertNotNull((String)("returned paths should not be null. path #" + count), (Object)path);
            ++count;
        }
        Assert.assertEquals((long)13L, (long)count);
    }

    @Test
    public void testBreadthFirst() throws Exception {
        Traverser traverser = Traversal.traversal().breadthFirst().traverse(TreeGraphTest.node("1"));
        Stack<Set<String>> levels = new Stack<Set<String>>();
        levels.push(new HashSet<String>(Arrays.asList("5", "6", "7", "8", "9", "A", "B", "C", "D")));
        levels.push(new HashSet<String>(Arrays.asList("2", "3", "4")));
        levels.push(new HashSet<String>(Arrays.asList("1")));
        this.assertLevels(traverser, levels);
    }

    @Test
    public void testDepthFirstTraversalReturnsNodesOnCorrectDepths() throws Exception {
        Traverser traverser = Traversal.traversal().depthFirst().traverse(TreeGraphTest.node("1"));
        int i = 0;
        for (Path pos : traverser) {
            Assert.assertEquals((long)this.expectedDepth(i++), (long)pos.length());
        }
        Assert.assertEquals((long)13L, (long)i);
    }

    @Test
    public void testPostorderDepthFirstReturnsDeeperNodesFirst() {
        Traverser traverser = Traversal.traversal().order(Traversal.postorderDepthFirst()).traverse(TreeGraphTest.node("1"));
        int i = 0;
        ArrayList<String> encounteredNodes = new ArrayList<String>();
        for (Path pos : traverser) {
            encounteredNodes.add((String)pos.endNode().getProperty("name"));
            Assert.assertEquals((long)this.expectedDepth(12 - i++), (long)pos.length());
        }
        Assert.assertEquals((long)13L, (long)i);
        Assert.assertTrue((encounteredNodes.indexOf("5") < encounteredNodes.indexOf("2") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("6") < encounteredNodes.indexOf("2") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("7") < encounteredNodes.indexOf("2") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("8") < encounteredNodes.indexOf("3") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("9") < encounteredNodes.indexOf("3") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("A") < encounteredNodes.indexOf("3") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("B") < encounteredNodes.indexOf("4") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("C") < encounteredNodes.indexOf("4") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("D") < encounteredNodes.indexOf("4") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("2") < encounteredNodes.indexOf("1") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("3") < encounteredNodes.indexOf("1") ? 1 : 0) != 0);
        Assert.assertTrue((encounteredNodes.indexOf("4") < encounteredNodes.indexOf("1") ? 1 : 0) != 0);
    }

    @Test
    public void testPostorderBreadthFirstReturnsDeeperNodesFirst() {
        Traverser traverser = Traversal.traversal().order(Traversal.postorderBreadthFirst()).traverse(TreeGraphTest.node("1"));
        Stack<Set<String>> levels = new Stack<Set<String>>();
        levels.push(new HashSet<String>(Arrays.asList("1")));
        levels.push(new HashSet<String>(Arrays.asList("2", "3", "4")));
        levels.push(new HashSet<String>(Arrays.asList("5", "6", "7", "8", "9", "A", "B", "C", "D")));
        this.assertLevels(traverser, levels);
    }

    private int expectedDepth(int i) {
        Assert.assertTrue((i < 13 ? 1 : 0) != 0);
        if (i == 0) {
            return 0;
        }
        if ((i - 1) % 4 == 0) {
            return 1;
        }
        return 2;
    }
}

