/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;

public class TestFileUtils {
    private File path;

    @Before
    public void doBefore() throws Exception {
        this.path = TargetDirectory.forTest(this.getClass()).directory("path", true);
    }

    @Test
    public void moveFileToDirectory() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = FileUtils.moveFileToDirectory((File)file, (File)targetDir);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    @Test
    public void moveFile() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = new File(targetDir, "new-name");
        FileUtils.moveFile((File)file, (File)newLocationOfFile);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    private File directory(String name) throws IOException {
        File dir = new File(this.path, name);
        dir.mkdirs();
        return dir;
    }

    private File touchFile(String name) throws IOException {
        File file = new File(this.path, name);
        file.createNewFile();
        return file;
    }
}

