/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class TestStringLogger {
    @Test
    public void makeSureLogsAreRotated() throws Exception {
        String path = "target/test-data/stringlogger";
        FileUtils.deleteRecursively((File)new File(path));
        File logFile = new File(path, "messages.log");
        File oldFile = new File(path, "messages.log.1");
        File oldestFile = new File(path, "messages.log.2");
        StringLogger logger = StringLogger.logger((String)path, (int)204800);
        Assert.assertFalse((boolean)oldFile.exists());
        int counter = 0;
        String prefix = "Bogus message ";
        while (!oldFile.exists()) {
            logger.logMessage(prefix + counter++, true);
        }
        int mark1 = counter - 1;
        logger.logMessage(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldFile).first()).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        while (!oldestFile.exists()) {
            logger.logMessage(prefix + counter++, true);
        }
        int mark2 = counter - 1;
        logger.logMessage(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldestFile).first()).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldFile).first()).contains(prefix + mark2));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        long previousSize = 0L;
        while (true) {
            logger.logMessage(prefix + counter++, true);
            if (logFile.length() < previousSize) break;
            previousSize = logFile.length();
        }
        Assert.assertFalse((boolean)new File(path, "messages.log.3").exists());
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldestFile).first()).contains(prefix + mark2));
    }

    @Test
    public void makeSureRotationDoesNotRecurse() throws Exception {
        String baseMessage = "base message";
        File target = TargetDirectory.forTest(TestStringLogger.class).directory("recursionTest", true);
        final StringLogger logger = StringLogger.logger((String)target.getAbsolutePath(), (int)"base message".length());
        Runnable trigger = new Runnable(){

            @Override
            public void run() {
                logger.logMessage("base message from trigger", true);
            }
        };
        logger.addRotationListener(trigger);
        logger.logMessage("base message from main", true);
        File rotated = new File(target, "messages.log.1");
        Assert.assertTrue((String)"rotated file not present, should have been created", (boolean)rotated.exists());
        Pair<String, Integer> rotatedInfo = this.lastLineOfFile(rotated);
        Assert.assertTrue((String)"rotated file should have only stuff from main", (((String)rotatedInfo.first()).endsWith(" from main") && (Integer)rotatedInfo.other() == 1 ? 1 : 0) != 0);
        File current = new File(target, "messages.log");
        Assert.assertTrue((String)"should have created a new messages.log file", (boolean)current.exists());
        Pair<String, Integer> currentInfo = this.lastLineOfFile(current);
        Assert.assertTrue((String)"current file should have only stuff from trigger", (((String)currentInfo.first()).endsWith(" from trigger") && (Integer)currentInfo.other() == 1 ? 1 : 0) != 0);
    }

    private String firstLineOfFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String result = reader.readLine();
        reader.close();
        return result;
    }

    private Pair<String, Integer> lastLineOfFile(File file) throws Exception {
        int count = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        String result = null;
        while ((line = reader.readLine()) != null) {
            result = line;
            ++count;
        }
        reader.close();
        return Pair.of((Object)result, (Object)count);
    }
}

