/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.logging.BufferingLogger;

public class JVMCheckerTest {
    @Test
    public void shouldNotIssueWarningWhenUsingHotspotServerVmVersion6() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.6.0_37")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingHotspotClientVmVersion6() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) Client VM", "1.6.42_87")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvm() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("OpenJDK 64-Bit Server VM", "1.6.0_24")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"WARNING! You are using an unsupported Java runtime. Please use JDK 6."));
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvmVersion() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.7.0_05")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"WARNING! You are using an unsupported version of the JDK. Please use JDK 6."));
    }
}

