/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.model.MultipleFailureException;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.SubProcess;
import org.neo4j.test.subprocess.SubProcessTestRunner;
import org.neo4j.test.subprocess.SuspendedThreadsException;
import org.neo4j.test.subprocess.Task;

@Ignore(value="not stable enough")
@RunWith(value=SubProcessTestRunner.class)
public class TestSubProcessTestRunner {
    private static DebuggedThread waiter;
    private volatile String[] nulls = null;
    private static DebuggedThread suspended;

    @Test
    public void testsRunInASubprocess() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        Assert.assertEquals((Object)SubProcess.class.getName(), (Object)trace[trace.length - 1].getClassName());
    }

    @EnabledBreakpoints(value={"sleep forever", "wait for sleep"})
    @Test(expected=SuspendedThreadsException.class)
    public void breakpointsNeedToReleaseBeforeTheTestIsDone() {
        new Thread(){

            @Override
            public void run() {
                TestSubProcessTestRunner.this.triggerBreakpointThatNeverWakesUp();
            }
        }.start();
        this.triggerBreakpointThatWaitsForOtherBreakpoint();
    }

    @BreakpointTrigger(value="wait for sleep")
    private void triggerBreakpointThatWaitsForOtherBreakpoint() {
    }

    @BreakpointHandler(value={"wait for sleep"})
    public static void handleWait(DebugInterface di) {
        waiter = waiter != null ? null : di.thread().suspend(null);
    }

    @BreakpointTrigger(value="sleep forever")
    private void triggerBreakpointThatNeverWakesUp() {
    }

    @BreakpointHandler(value={"sleep forever"})
    public static void sleepForever(DebugInterface di) {
        if (waiter != null) {
            waiter.resume();
            waiter = null;
        } else {
            waiter = di.thread().suspend(null);
        }
    }

    @Ignore(value="does not work due to the threading policy of RMI")
    @EnabledBreakpoints(value={"testsCanBeBreakpoints"})
    @BreakpointTrigger
    @Test
    public void testsCanBeBreakpoints() throws Throwable {
        Assert.assertNotNull((String)"task execution failed to communicate message", (Object)this.nulls);
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (String id : this.nulls) {
            try {
                Assert.assertNotNull((String)id, null);
            }
            catch (Throwable e) {
                failures.add(e);
            }
        }
        MultipleFailureException.assertEmpty(failures);
    }

    @BreakpointHandler(value={"testsCanBeBreakpoints"})
    public static void validateInjections(DebugInterface di, BreakPoint self, @BreakpointHandler(value={"resume"}) BreakPoint resume, Task.Executor executor) {
        suspended = di.thread().suspend(null);
        resume.enable();
        HashMap<String, Object> injectable = new HashMap<String, Object>();
        injectable.put("self breakpoint", self);
        injectable.put(DebugInterface.class.getSimpleName(), di);
        injectable.put("referenced breakpoint", resume);
        injectable.put("task executor", executor);
        final String[] nulls = TestSubProcessTestRunner.validateNotNull(injectable);
        executor.submit(new Task<TestSubProcessTestRunner>(){

            @Override
            public void run(TestSubProcessTestRunner test) {
                test.resume(nulls);
            }
        });
    }

    @BreakpointTrigger(on=BreakPoint.Event.EXIT)
    private void resume(String[] nulls) {
        this.nulls = nulls;
    }

    @BreakpointHandler(value={"resume"})
    public static void handleResume() {
        suspended.resume();
        suspended = null;
    }

    private static String[] validateNotNull(Map<String, Object> injectable) {
        ArrayList nulls = new ArrayList();
        for (Map.Entry<String, Object> entry : injectable.entrySet()) {
        }
        return nulls.toArray(new String[nulls.size()]);
    }
}

