/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;

public abstract class AsciiDocGenerator {
    private static final String DOCUMENTATION_END = "\n...\n";
    private Logger log = Logger.getLogger(AsciiDocGenerator.class.getName());
    protected final String title;
    protected String section;
    protected String description = null;
    protected GraphDatabaseService graph;
    protected static final String SNIPPET_MARKER = "@@";
    protected Map<String, String> snippets = new HashMap<String, String>();
    private static final Map<String, Integer> counters = new HashMap<String, Integer>();

    public AsciiDocGenerator(String title, String section) {
        this.section = section;
        this.title = title.replace("_", " ");
    }

    public AsciiDocGenerator setGraph(GraphDatabaseService graph) {
        this.graph = graph;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public AsciiDocGenerator setSection(String section) {
        this.section = section;
        return this;
    }

    public AsciiDocGenerator description(String description) {
        if (description == null) {
            throw new IllegalArgumentException("The description can not be null");
        }
        int pos = description.indexOf(DOCUMENTATION_END);
        String content = pos != -1 ? description.substring(0, pos) : description;
        this.description = this.description == null ? content : this.description + "\n\n" + content;
        return this;
    }

    protected void line(Writer fw, String string) throws IOException {
        fw.append(string);
        fw.append("\n");
    }

    public static Writer getFW(String dir, String title) {
        try {
            File dirs = new File(dir);
            String name = title.replace(" ", "-").toLowerCase() + ".asciidoc";
            return AsciiDocGenerator.getFW(dirs, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Writer getFW(File dir, String filename) {
        try {
            File out;
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((out = new File(dir, filename)).exists()) {
                out.delete();
            }
            if (!out.createNewFile()) {
                throw new RuntimeException("File exists: " + out.getAbsolutePath());
            }
            return new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpToSeparateFile(File dir, String testId, String content) {
        int pos;
        if (content == null || content.isEmpty()) {
            throw new IllegalArgumentException("The content can not be empty(" + content + ").");
        }
        String filename = testId + ".asciidoc";
        Writer writer = AsciiDocGenerator.getFW(new File(dir, "includes"), filename);
        String title = "";
        char firstChar = content.charAt(0);
        if ((firstChar == '.' || firstChar == '_') && (pos = content.indexOf(10)) != -1) {
            title = content.substring(0, pos + 1);
            content = content.substring(pos + 1);
        }
        try {
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return title + "include::includes/" + filename + "[]\n";
    }

    public static String dumpToSeparateFileWithType(File dir, String type, String content) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("The type can not be null or empty: [" + type + "]");
        }
        String key = dir.getAbsolutePath() + type;
        Integer counter = counters.get(key);
        if (counter == null) {
            counter = 0;
        }
        Integer n = counter;
        Integer n2 = counter = Integer.valueOf(counter + 1);
        counters.put(key, counter);
        String testId = type + "-" + String.valueOf(counter);
        return AsciiDocGenerator.dumpToSeparateFile(dir, testId, content);
    }

    public static PrintWriter getPrintWriter(String dir, String title) {
        return new PrintWriter(AsciiDocGenerator.getFW(dir, title));
    }

    public static String getPath(Class<?> source) {
        return source.getPackage().getName().replace(".", "/") + "/" + source.getSimpleName() + ".java";
    }

    protected String replaceSnippets(String description, File dir, String title) {
        for (String key : this.snippets.keySet()) {
            description = this.replaceSnippet(description, key, dir, title);
        }
        if (description.contains(SNIPPET_MARKER)) {
            int indexOf = description.indexOf(SNIPPET_MARKER);
            String snippet = description.substring(indexOf, description.indexOf("\n", indexOf));
            this.log.severe("missing snippet [" + snippet + "] in " + description);
        }
        return description;
    }

    private String replaceSnippet(String description, String key, File dir, String title) {
        String snippetString = SNIPPET_MARKER + key;
        if (description.contains(snippetString + "\n")) {
            String include = AsciiDocGenerator.dumpToSeparateFile(dir, title + "-" + key, this.snippets.get(key));
            description = description.replace(snippetString + "\n", include);
        } else {
            this.log.severe("Could not find " + snippetString + "\\n in " + description);
        }
        return description;
    }

    public void addSnippet(String key, String content) {
        this.snippets.put(key, content);
    }

    public void addTestSourceSnippets(Class<?> source, String ... tagNames) {
        for (String tagName : tagNames) {
            this.addSnippet(tagName, AsciiDocGenerator.sourceSnippet(tagName, source, "test-sources"));
        }
    }

    public void addSourceSnippets(Class<?> source, String ... tagNames) {
        for (String tagName : tagNames) {
            this.addSnippet(tagName, AsciiDocGenerator.sourceSnippet(tagName, source, "sources"));
        }
    }

    private static String sourceSnippet(String tagName, Class<?> source, String classifier) {
        return "[snippet,java]\n----\ncomponent=${project.artifactId}\nsource=" + AsciiDocGenerator.getPath(source) + "\n" + "classifier=" + classifier + "\n" + "tag=" + tagName + "\n" + "----\n";
    }

    public void addGithubTestSourceLink(String key, Class<?> source, String repo, String dir) {
        this.githubLink(key, source, repo, dir, "test");
    }

    public void addGithubSourceLink(String key, Class<?> source, String repo, String dir) {
        this.githubLink(key, source, repo, dir, "main");
    }

    private void githubLink(String key, Class<?> source, String repo, String dir, String mainOrTest) {
        String path = "https://github.com/" + repo + "/blob/{neo4j-git-tag}/";
        if (dir != null) {
            path = path + dir + "/";
        }
        path = path + "src/" + mainOrTest + "/java/" + AsciiDocGenerator.getPath(source);
        path = path + "[" + source.getSimpleName() + ".java]\n";
        this.addSnippet(key, path);
    }
}

