/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class BatchTransaction {
    private static final int MAX_SIZE = 10000;
    private final GraphDatabaseService db;
    private Transaction tx;
    private int txSize;
    private int total;
    private boolean printProgress;
    private final int maxSize;

    public static BatchTransaction beginBatchTx(GraphDatabaseService db) {
        return new BatchTransaction(db, 10000);
    }

    public static BatchTransaction beginBatchTx(GraphDatabaseService db, int maxSize) {
        return new BatchTransaction(db, maxSize);
    }

    private BatchTransaction(GraphDatabaseService db, int maxSize) {
        this.db = db;
        this.maxSize = maxSize;
        this.beginTx();
    }

    private void beginTx() {
        this.tx = this.db.beginTx();
    }

    public GraphDatabaseService getDb() {
        return this.db;
    }

    public boolean increment() {
        return this.increment(1);
    }

    public boolean increment(int count) {
        this.txSize += count;
        ++this.total;
        if (this.txSize >= 10000) {
            if (this.printProgress) {
                System.out.println(this.total);
            }
            this.txSize = 0;
            this.finish();
            this.beginTx();
            return true;
        }
        return false;
    }

    public void restart() {
        this.finish();
        this.beginTx();
    }

    public void finish() {
        this.tx.success();
        this.tx.finish();
    }

    public int size() {
        return this.txSize;
    }

    public int limit() {
        return 10000;
    }

    public int total() {
        return this.total;
    }

    public void printProgress(boolean value) {
        this.printProgress = value;
    }
}

