/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.test.TargetDirectory;

public abstract class GraphStoreFixture
implements TestRule {
    private String directory;
    private int localIdGenerator = 0;
    private long nodeId;
    private long relId;
    private long propId;
    private long stringPropId;
    private long arrayPropId;
    private int relTypeId;
    private int propKeyId;

    public void apply(Transaction transaction) throws IOException {
        this.applyTransaction(this.write(transaction, null));
    }

    public StoreAccess storeAccess() {
        return new StoreAccess(this.directory);
    }

    public File directory() {
        return new File(this.directory);
    }

    protected abstract void generateInitialData(GraphDatabaseService var1);

    protected void start(String storeDir) {
    }

    protected void stop() {
    }

    protected int myId() {
        return 1;
    }

    protected int masterId() {
        return -1;
    }

    protected final ReadableByteChannel write(Transaction transaction, Long txId) throws IOException {
        return transaction.write(new IdGenerator(), this.localIdGenerator++, this.masterId(), this.myId(), txId);
    }

    protected void applyTransaction(ReadableByteChannel transaction) throws IOException {
        EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(this.directory, this.configuration(false));
        try {
            database.beginTx();
            database.getXaDataSourceManager().getNeoStoreDataSource().applyPreparedTransaction(transaction);
        }
        catch (XAException e) {
            throw new IOException(e);
        }
        finally {
            database.shutdown();
        }
    }

    protected Map<String, String> configuration(boolean initialData) {
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInitialData() {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(this.directory, this.configuration(true));
        try {
            this.generateInitialData((GraphDatabaseService)graphDb);
            StoreAccess stores = new StoreAccess((InternalAbstractGraphDatabase)graphDb);
            this.nodeId = stores.getNodeStore().getHighId();
            this.relId = stores.getRelationshipStore().getHighId();
            this.propId = stores.getPropertyStore().getHighId();
            this.stringPropId = stores.getStringStore().getHighId();
            this.arrayPropId = stores.getArrayStore().getHighId();
            this.relTypeId = (int)stores.getRelationshipTypeStore().getHighId();
            this.propKeyId = (int)stores.getPropertyKeyStore().getHighId();
        }
        finally {
            graphDb.shutdown();
        }
    }

    public Statement apply(final Statement base, Description description) {
        final TargetDirectory.TestDirectory directory = TargetDirectory.forTest(description.getTestClass()).cleanTestDirectory();
        return directory.apply(new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                GraphStoreFixture.this.directory = directory.directory().getAbsolutePath();
                try {
                    GraphStoreFixture.this.generateInitialData();
                    GraphStoreFixture.this.start(GraphStoreFixture.this.directory);
                    try {
                        base.evaluate();
                    }
                    finally {
                        GraphStoreFixture.this.stop();
                    }
                }
                finally {
                    GraphStoreFixture.this.directory = null;
                }
            }
        }, description);
    }

    public static final class TransactionDataBuilder {
        private final TransactionWriter writer;

        public TransactionDataBuilder(TransactionWriter writer) {
            this.writer = writer;
        }

        public void propertyKey(int id, String key) {
            try {
                this.writer.propertyKey(id, key, new int[]{id});
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void relationshipType(int id, String label) {
            try {
                this.writer.propertyKey(id, label, new int[]{id});
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void create(NodeRecord node) {
            try {
                this.writer.create(node);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void update(NeoStoreRecord record) {
            try {
                this.writer.update(record);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void update(NodeRecord node) {
            try {
                this.writer.update(node);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void delete(NodeRecord node) {
            try {
                this.writer.delete(node);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void create(RelationshipRecord relationship) {
            try {
                this.writer.create(relationship);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void update(RelationshipRecord relationship) {
            try {
                this.writer.update(relationship);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void delete(RelationshipRecord relationship) {
            try {
                this.writer.delete(relationship);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void create(PropertyRecord property) {
            try {
                this.writer.create(property);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void update(PropertyRecord property) {
            try {
                this.writer.update(property);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        public void delete(PropertyRecord property) {
            try {
                this.writer.delete(property);
            }
            catch (IOException e) {
                throw this.ioError(e);
            }
        }

        private Error ioError(IOException e) {
            return new Error("InMemoryLogBuffer should not throw IOException", e);
        }
    }

    public class IdGenerator {
        public long node() {
            return GraphStoreFixture.this.nodeId++;
        }

        public long relationship() {
            return GraphStoreFixture.this.relId++;
        }

        public long property() {
            return GraphStoreFixture.this.propId++;
        }

        public long stringProperty() {
            return GraphStoreFixture.this.stringPropId++;
        }

        public long arrayProperty() {
            return GraphStoreFixture.this.arrayPropId++;
        }

        public int relationshipType() {
            return GraphStoreFixture.this.relTypeId++;
        }

        public int propertyKey() {
            return GraphStoreFixture.this.propKeyId++;
        }
    }

    public static abstract class Transaction {
        public final long startTimestamp = System.currentTimeMillis();
        public final byte[] globalId = XidImpl.getNewGlobalId();

        protected abstract void transactionData(TransactionDataBuilder var1, IdGenerator var2);

        private ReadableByteChannel write(IdGenerator idGenerator, int localId, int masterId, int myId, Long txId) throws IOException {
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            TransactionWriter writer = new TransactionWriter((LogBuffer)buffer, localId);
            writer.start(this.globalId, masterId, myId, this.startTimestamp);
            this.transactionData(new TransactionDataBuilder(writer), idGenerator);
            writer.prepare();
            if (txId != null) {
                writer.commit(false, txId.longValue());
                writer.done();
            }
            return buffer;
        }
    }
}

