/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.util.DumpLogicalLog;

public class LogTestUtils {
    public static final LogHook<Pair<Byte, List<byte[]>>> EVERYTHING_BUT_DONE_RECORDS = new LogHook<Pair<Byte, List<byte[]>>>(){

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            return (Byte)item.first() != 4;
        }

        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    };
    public static final LogHook<Pair<Byte, List<byte[]>>> NO_FILTER = new LogHook<Pair<Byte, List<byte[]>>>(){

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            return true;
        }

        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    };
    public static final LogHook<Pair<Byte, List<byte[]>>> PRINT_DANGLING = new LogHook<Pair<Byte, List<byte[]>>>(){
        private final Map<ByteArray, List<Xid>> xids = new HashMap<ByteArray, List<Xid>>();

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            List<Xid> removed;
            if ((Byte)item.first() == 2) {
                ByteArray key = new ByteArray((byte[])((List)item.other()).get(0));
                List<Xid> list = this.xids.get(key);
                if (list == null) {
                    list = new ArrayList<Xid>();
                    this.xids.put(key, list);
                }
                XidImpl xid = new XidImpl((byte[])((List)item.other()).get(0), (byte[])((List)item.other()).get(1));
                list.add((Xid)xid);
            } else if ((Byte)item.first() == 4 && (removed = this.xids.remove(new ByteArray((byte[])((List)item.other()).get(0)))) == null) {
                throw new IllegalArgumentException("Not found");
            }
            return true;
        }

        @Override
        public void file(File file) {
            this.xids.clear();
            System.out.println("=== " + file + " ===");
        }

        @Override
        public void done(File file) {
            for (List<Xid> xid : this.xids.values()) {
                System.out.println("dangling " + xid);
            }
        }
    };

    public static void filterTxLog(String storeDir, LogHook<Pair<Byte, List<byte[]>>> filter) throws IOException {
        LogTestUtils.filterTxLog(storeDir, filter, 0L);
    }

    public static void filterTxLog(String storeDir, LogHook<Pair<Byte, List<byte[]>>> filter, long startPosition) throws IOException {
        for (File file : LogTestUtils.oneOrTwo(new File(storeDir, "tm_tx_log"))) {
            LogTestUtils.filterTxLog(file, filter, startPosition);
        }
    }

    public static void filterTxLog(File file, LogHook<Pair<Byte, List<byte[]>>> filter) throws IOException {
        LogTestUtils.filterTxLog(file, filter, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterTxLog(File file, LogHook<Pair<Byte, List<byte[]>>> filter, long startPosition) throws IOException {
        File tempFile = new File(file.getAbsolutePath() + ".tmp");
        FileChannel in = new RandomAccessFile(file, "r").getChannel();
        in.position(startPosition);
        FileChannel out = new RandomAccessFile(tempFile, "rw").getChannel();
        DirectMappedLogBuffer outBuffer = new DirectMappedLogBuffer(out);
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        try {
            filter.file(file);
            in.read(buffer);
            buffer.flip();
            while (buffer.hasRemaining()) {
                byte type = buffer.get();
                List<byte[]> xids = null;
                if (type == 1) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else if (type == 2) {
                    xids = LogTestUtils.readXids(buffer, 2);
                } else if (type == 3) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else if (type == 4) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else {
                    throw new IllegalArgumentException("Unknown type:" + type + ", position:" + (in.position() - (long)buffer.remaining()));
                }
                if (!filter.accept(Pair.of((Object)type, xids))) continue;
                outBuffer.put(type);
                LogTestUtils.writeXids(xids, (LogBuffer)outBuffer);
            }
        }
        finally {
            LogTestUtils.safeClose(in);
            outBuffer.force();
            LogTestUtils.safeClose(out);
            filter.done(file);
        }
        LogTestUtils.replace(tempFile, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertLogContains(String logPath, LogEntry ... expectedEntries) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(logPath, "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        try {
            LogEntry entry;
            LogIoUtils.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (boolean)true);
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            DumpLogicalLog.CommandFactory cmdFactory = new DumpLogicalLog.CommandFactory();
            while ((entry = LogIoUtils.readEntry((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (XaCommandFactory)cmdFactory)) != null) {
                entries.add(entry);
            }
            for (int entryNo = 0; entryNo < expectedEntries.length; ++entryNo) {
                LogEntry expectedEntry = expectedEntries[entryNo];
                if (entries.size() <= entryNo) {
                    junit.framework.Assert.fail((String)("Log ended prematurely. Expected to find '" + expectedEntry.toString() + "' as log entry number " + entryNo + ", instead there were no more log entries."));
                }
                LogEntry actualEntry = (LogEntry)entries.get(entryNo);
                Assert.assertThat((String)("Unexpected entry at entry number " + entryNo), (Object)actualEntry, (Matcher)Is.is((Object)expectedEntry));
            }
            Assert.assertThat((String)"The log contained more entries than we expected!", (Object)entries.size(), (Matcher)Is.is((Object)expectedEntries.length));
        }
        finally {
            fileChannel.close();
        }
    }

    private static void replace(File tempFile, File file) {
        file.renameTo(new File(file.getAbsolutePath() + "." + System.currentTimeMillis()));
        tempFile.renameTo(file);
    }

    public static File[] filterNeostoreLogicalLog(String storeDir, LogHook<LogEntry> filter) throws IOException {
        File[] logFiles;
        for (File file : logFiles = LogTestUtils.oneOrTwo(new File(storeDir, "nioneo_logical.log"))) {
            File filteredLog = LogTestUtils.filterNeostoreLogicalLog(file, filter);
            LogTestUtils.replace(filteredLog, file);
        }
        return logFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File filterNeostoreLogicalLog(File file, LogHook<LogEntry> filter) throws IOException {
        filter.file(file);
        File tempFile = new File(file.getAbsolutePath() + ".tmp");
        FileChannel in = new RandomAccessFile(file, "r").getChannel();
        FileChannel out = new RandomAccessFile(tempFile, "rw").getChannel();
        DirectMappedLogBuffer outBuffer = new DirectMappedLogBuffer(out);
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        LogTestUtils.transferLogicalLogHeader(in, (LogBuffer)outBuffer, buffer);
        DumpLogicalLog.CommandFactory cf = new DumpLogicalLog.CommandFactory();
        try {
            LogEntry entry = null;
            while ((entry = LogIoUtils.readEntry((ByteBuffer)buffer, (ReadableByteChannel)in, (XaCommandFactory)cf)) != null) {
                if (!filter.accept(entry)) continue;
                LogIoUtils.writeLogEntry((LogEntry)entry, (LogBuffer)outBuffer);
            }
        }
        finally {
            LogTestUtils.safeClose(in);
            outBuffer.force();
            LogTestUtils.safeClose(out);
            filter.done(file);
        }
        return tempFile;
    }

    private static void transferLogicalLogHeader(FileChannel in, LogBuffer outBuffer, ByteBuffer buffer) throws IOException {
        long[] header = LogIoUtils.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)in, (boolean)true);
        LogIoUtils.writeLogHeader((ByteBuffer)buffer, (long)header[0], (long)header[1]);
        byte[] headerBytes = new byte[buffer.limit()];
        buffer.get(headerBytes);
        outBuffer.put(headerBytes);
    }

    private static void safeClose(FileChannel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeXids(List<byte[]> xids, LogBuffer outBuffer) throws IOException {
        for (byte[] xid : xids) {
            outBuffer.put((byte)xid.length);
        }
        for (byte[] xid : xids) {
            outBuffer.put(xid);
        }
    }

    private static List<byte[]> readXids(ByteBuffer buffer, int count) {
        byte[] counts = new byte[count];
        for (int i = 0; i < count; ++i) {
            counts[i] = buffer.get();
        }
        ArrayList<byte[]> xids = new ArrayList<byte[]>();
        for (int i = 0; i < count; ++i) {
            xids.add(LogTestUtils.readXid(buffer, counts[i]));
        }
        return xids;
    }

    private static byte[] readXid(ByteBuffer buffer, byte length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    private static File[] oneOrTwo(File file) {
        File two;
        ArrayList<File> files = new ArrayList<File>();
        File one = new File(file.getAbsolutePath() + ".1");
        if (one.exists()) {
            files.add(one);
        }
        if ((two = new File(file.getAbsolutePath() + ".2")).exists()) {
            files.add(two);
        }
        if (files.isEmpty()) {
            throw new IllegalStateException("Couldn't find any active tm log");
        }
        return files.toArray(new File[files.size()]);
    }

    private static class ByteArray {
        private final byte[] bytes;

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.bytes, ((ByteArray)obj).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(File var1);

        public void done(File var1);
    }
}

