/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.test.StreamConsumer;

public class ProcessStreamHandler {
    private final Thread out;
    private final Thread err;
    private Process process;

    public ProcessStreamHandler(Process process, boolean quiet) {
        this.process = process;
        this.out = new Thread(new StreamConsumer(process.getInputStream(), System.out, quiet));
        this.err = new Thread(new StreamConsumer(process.getErrorStream(), System.err, quiet));
    }

    public void launch() {
        this.out.start();
        this.err.start();
    }

    public void done() {
        try {
            this.out.join();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            e.printStackTrace();
        }
        try {
            this.err.join();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.out.interrupt();
        this.err.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForResult() {
        this.launch();
        try {
            int n = this.process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            int n = 0;
            return n;
        }
        finally {
            this.done();
        }
    }
}

