/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class StreamConsumer
implements Runnable {
    private final Reader in;
    private final Writer out;
    private static final int BUFFER_SIZE = 32;
    private boolean quiet;

    public StreamConsumer(InputStream in, OutputStream out, boolean quiet) {
        this.quiet = quiet;
        this.in = new InputStreamReader(in);
        this.out = new OutputStreamWriter(out);
    }

    @Override
    public void run() {
        try {
            int count;
            char[] cbuf = new char[32];
            while ((count = this.in.read(cbuf, 0, 32)) >= 0) {
                if (this.quiet) continue;
                this.out.write(cbuf, 0, count);
            }
            this.out.flush();
        }
        catch (IOException exc) {
            System.err.println("Child I/O Transfer - " + exc);
        }
    }
}

