/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.impl.MultipleExceptionsStrategy;

public class EphemeralFileSystemAbstraction
implements FileSystemAbstraction,
Lifecycle {
    private final Map<String, EphemeralFileData> files = new HashMap<String, EphemeralFileData>();

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        for (EphemeralFileData file : this.files.values()) {
            this.free(file);
        }
        this.files.clear();
        DynamicByteBuffer.dispose();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public void assertNoOpenFiles() throws Exception {
        ArrayList<FileStillOpenException> open = new ArrayList<FileStillOpenException>();
        for (EphemeralFileData file : this.files.values()) {
            for (EphemeralFileChannel channel : IteratorUtil.loop(file.getOpenChannels())) {
                open.add(channel.openedAt);
            }
        }
        MultipleExceptionsStrategy.assertEmptyExceptions(open);
    }

    private void free(EphemeralFileData file) {
        if (file != null) {
            file.fileAsBuffer.free();
        }
    }

    public synchronized FileChannel open(String fileName, String mode) throws IOException {
        EphemeralFileData data = this.files.get(fileName);
        return data != null ? new EphemeralFileChannel(data, new FileStillOpenException(fileName)) : this.create(fileName);
    }

    public org.neo4j.kernel.impl.nioneo.store.FileLock tryLock(String fileName, FileChannel channel) throws IOException {
        if (channel instanceof EphemeralFileChannel) {
            EphemeralFileChannel efc = (EphemeralFileChannel)channel;
            final FileLock lock = efc.tryLock();
            return new org.neo4j.kernel.impl.nioneo.store.FileLock(){

                public void release() throws IOException {
                    lock.release();
                }
            };
        }
        System.err.println("WARNING: locking non-ephemeral FileChannel[" + channel + "] through EphemeralFileSystem, for: " + fileName);
        return org.neo4j.kernel.impl.nioneo.store.FileLock.getOsSpecificFileLock((String)fileName, (FileChannel)channel);
    }

    public synchronized FileChannel create(String fileName) throws IOException {
        EphemeralFileData data = new EphemeralFileData();
        this.free(this.files.put(fileName, data));
        return new EphemeralFileChannel(data, new FileStillOpenException(fileName));
    }

    public long getFileSize(String fileName) {
        EphemeralFileData file = this.files.get(fileName);
        return file == null ? 0L : file.size();
    }

    public boolean fileExists(String fileName) {
        return this.files.containsKey(fileName);
    }

    public boolean deleteFile(String fileName) {
        this.free(this.files.remove(fileName));
        return true;
    }

    public boolean renameFile(String from, String to) throws IOException {
        if (!this.files.containsKey(from)) {
            throw new IOException("'" + from + "' doesn't exist");
        }
        if (this.files.containsKey(to)) {
            throw new IOException("'" + to + "' already exists");
        }
        this.files.put(to, this.files.remove(from));
        return true;
    }

    public void copyFile(String from, String to) throws IOException {
        if (!this.files.containsKey(from)) {
            throw new IOException("'" + from + "' doesn't exist");
        }
        if (this.files.containsKey(to)) {
            throw new IOException("'" + to + "' already exists");
        }
        this.files.put(to, this.files.get(from).clone());
    }

    private static class DynamicByteBuffer {
        private static final int[] SIZES;
        private static volatile AtomicReferenceArray<Queue<Reference<ByteBuffer>>> POOL;
        private static final byte[] zeroBuffer;
        private ByteBuffer buf;

        static void dispose() {
            for (int i = POOL.length(); i < POOL.length(); ++i) {
                for (Reference reference : POOL.get(i)) {
                    ByteBuffer byteBuffer = (ByteBuffer)reference.get();
                    if (byteBuffer == null) continue;
                    try {
                        DynamicByteBuffer.destroyDirectByteBuffer(byteBuffer);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            DynamicByteBuffer.init();
        }

        public DynamicByteBuffer clone() {
            return new DynamicByteBuffer(this.buf);
        }

        private static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
            Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
            cleanMethod.invoke(cleaner, new Object[0]);
        }

        private static void init() {
            POOL = new AtomicReferenceArray(SIZES.length);
            AtomicReferenceArray pool = POOL;
            for (int i = 0; i < SIZES.length; ++i) {
                pool.set(i, new ConcurrentLinkedQueue());
            }
        }

        public DynamicByteBuffer() {
            this.buf = this.allocate(0);
        }

        private DynamicByteBuffer(ByteBuffer toClone) {
            int sizeIndex = toClone.capacity() / SIZES[SIZES.length - 1];
            this.buf = this.allocate(sizeIndex);
            this.copyByteBufferContents(toClone, this.buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyByteBufferContents(ByteBuffer from, ByteBuffer to) {
            int positionBefore = from.position();
            int limitBefore = from.limit();
            byte[] scratchPad = new byte[8096];
            try {
                from.position(0);
                while (from.remaining() > 0) {
                    int bytes = Math.min(scratchPad.length, from.remaining());
                    from.get(scratchPad, 0, bytes);
                    to.put(scratchPad, 0, bytes);
                }
            }
            finally {
                from.limit(limitBefore);
                from.position(positionBefore);
                to.limit(limitBefore);
                to.position(0);
            }
        }

        private ByteBuffer allocate(int sizeIndex) {
            for (int enlargement = 0; enlargement < 2; ++enlargement) {
                Reference<ByteBuffer> ref;
                Queue<Reference<ByteBuffer>> queue;
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
                if (sizeIndex + enlargement >= pool.length() || (queue = pool.get(sizeIndex + enlargement)) == null) continue;
                while ((ref = queue.poll()) != null) {
                    ByteBuffer buffer = ref.get();
                    if (buffer == null) continue;
                    return buffer;
                }
            }
            return ByteBuffer.allocateDirect(sizeIndex < SIZES.length ? SIZES[sizeIndex] : (sizeIndex - SIZES.length + 1) * SIZES[SIZES.length - 1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free() {
            try {
                int sizeIndex;
                this.clear();
                if (sizeIndex == 0) {
                    for (sizeIndex = this.buf.capacity() / SIZES[SIZES.length - 1]; sizeIndex < SIZES.length && this.buf.capacity() != SIZES[sizeIndex]; ++sizeIndex) {
                    }
                } else {
                    sizeIndex += SIZES.length - 1;
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
                SoftReference<ByteBuffer> ref = new SoftReference<ByteBuffer>(this.buf);
                (sizeIndex < pool.length() ? pool.get(sizeIndex) : DynamicByteBuffer.growPool(sizeIndex)).add(ref);
            }
            finally {
                this.buf = null;
            }
        }

        private static synchronized Queue<Reference<ByteBuffer>> growPool(int sizeIndex) {
            AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
            if (sizeIndex >= pool.length()) {
                int i;
                int newSize;
                for (newSize = pool.length(); sizeIndex >= newSize; newSize <<= 1) {
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> newPool = new AtomicReferenceArray<Queue<Reference<ByteBuffer>>>(newSize);
                for (i = 0; i < pool.length(); ++i) {
                    newPool.set(i, pool.get(i));
                }
                for (i = pool.length(); i < newPool.length(); ++i) {
                    newPool.set(i, new ConcurrentLinkedQueue());
                }
                POOL = pool = newPool;
            }
            return pool.get(sizeIndex);
        }

        void put(int pos, byte[] bytes, int offset, int length) {
            this.buf.position(pos);
            this.verifySize(length);
            this.buf.put(bytes, offset, length);
        }

        void get(int pos, byte[] scratchPad, int i, int howMuchToReadThisTime) {
            this.buf.position(pos);
            this.buf.get(scratchPad, i, howMuchToReadThisTime);
        }

        void fillWithZeros(int pos, int bytes) {
            this.buf.position(pos);
            while (bytes > 0) {
                int howMuchToReadThisTime = Math.min(bytes, zeroBuffer.length);
                this.buf.put(zeroBuffer, 0, howMuchToReadThisTime);
                bytes -= howMuchToReadThisTime;
            }
        }

        private void verifySize(int amount) {
            if (this.buf.remaining() >= amount) {
                return;
            }
            int newSize = this.buf.capacity();
            int sizeIndex = newSize / SIZES[SIZES.length - 1];
            if (sizeIndex == 0) {
                while (sizeIndex < SIZES.length && newSize != SIZES[sizeIndex]) {
                    ++sizeIndex;
                }
            } else {
                sizeIndex += SIZES.length - 1;
            }
            int required = newSize + amount - this.buf.remaining();
            while (newSize < required) {
                newSize += Math.min(newSize, 0x100000);
                ++sizeIndex;
            }
            int oldPosition = this.buf.position();
            ByteBuffer buf = this.allocate(sizeIndex);
            this.buf.position(0);
            buf.put(this.buf);
            this.buf = buf;
            this.buf.position(oldPosition);
        }

        public void clear() {
            this.buf.clear();
        }

        static {
            zeroBuffer = new byte[1024];
            int K = 1024;
            SIZES = new int[]{64 * K, 128 * K, 256 * K, 512 * K, 1024 * K};
            DynamicByteBuffer.init();
        }
    }

    private static class EphemeralFileLock
    extends FileLock {
        private EphemeralFileData file;

        EphemeralFileLock(EphemeralFileChannel channel, EphemeralFileData file) {
            super(channel, 0L, Long.MAX_VALUE, false);
            this.file = file;
            file.locked++;
        }

        @Override
        public boolean isValid() {
            return this.file != null;
        }

        @Override
        public void release() throws IOException {
            if (this.file == null || this.file.locked == 0) {
                return;
            }
            this.file.locked--;
            this.file = null;
        }
    }

    private static class EphemeralFileData {
        private final DynamicByteBuffer fileAsBuffer = new DynamicByteBuffer();
        private final byte[] scratchPad = new byte[1024];
        private final Collection<WeakReference<EphemeralFileChannel>> channels = new LinkedList<WeakReference<EphemeralFileChannel>>();
        private int size;
        private int locked;

        private EphemeralFileData() {
        }

        int read(EphemeralFileChannel fc, ByteBuffer dst) {
            int howMuchToReadThisTime;
            int wanted = dst.limit();
            int available = Math.min(wanted, (int)((long)this.size - fc.position));
            if (available == 0) {
                return -1;
            }
            for (int pending = available; pending > 0; pending -= howMuchToReadThisTime) {
                howMuchToReadThisTime = Math.min(pending, this.scratchPad.length);
                this.fileAsBuffer.get((int)fc.position, this.scratchPad, 0, howMuchToReadThisTime);
                fc.position += (long)howMuchToReadThisTime;
                dst.put(this.scratchPad, 0, howMuchToReadThisTime);
            }
            return available;
        }

        public EphemeralFileData clone() {
            EphemeralFileData copy = new EphemeralFileData();
            copy.size = this.size;
            return copy;
        }

        void open(EphemeralFileChannel channel) {
            this.channels.add(new WeakReference<EphemeralFileChannel>(channel));
        }

        void close(EphemeralFileChannel channel) {
            this.locked = 0;
            Iterator<EphemeralFileChannel> iter = this.getOpenChannels();
            while (iter.hasNext()) {
                if (iter.next() != channel) continue;
                iter.remove();
            }
        }

        Iterator<EphemeralFileChannel> getOpenChannels() {
            final Iterator<WeakReference<EphemeralFileChannel>> refs = this.channels.iterator();
            return new PrefetchingIterator<EphemeralFileChannel>(){

                protected EphemeralFileChannel fetchNextOrNull() {
                    while (refs.hasNext()) {
                        EphemeralFileChannel channel = (EphemeralFileChannel)((WeakReference)refs.next()).get();
                        if (channel != null) {
                            return channel;
                        }
                        refs.remove();
                    }
                    return null;
                }

                public void remove() {
                    refs.remove();
                }
            };
        }

        boolean isOpen() {
            return this.getOpenChannels().hasNext();
        }

        int write(EphemeralFileChannel fc, ByteBuffer src) {
            int wanted;
            int howMuchToWriteThisTime;
            for (int pending = wanted = src.limit(); pending > 0; pending -= howMuchToWriteThisTime) {
                howMuchToWriteThisTime = Math.min(pending, this.scratchPad.length);
                src.get(this.scratchPad, 0, howMuchToWriteThisTime);
                this.fileAsBuffer.put((int)fc.position, this.scratchPad, 0, howMuchToWriteThisTime);
                fc.position += (long)howMuchToWriteThisTime;
            }
            int newSize = Math.max(this.size, (int)fc.position);
            int intermediaryBytes = newSize - wanted - this.size;
            if (intermediaryBytes > 0) {
                this.fileAsBuffer.fillWithZeros(this.size, intermediaryBytes);
                this.fileAsBuffer.buf.position(this.size);
            }
            this.size = newSize;
            return wanted;
        }

        long size() {
            return this.size;
        }

        void truncate(long newSize) {
            this.size = (int)newSize;
        }

        boolean lock() {
            return this.locked == 0;
        }
    }

    private static class EphemeralFileChannel
    extends FileChannel {
        final FileStillOpenException openedAt;
        private final EphemeralFileData data;
        long position = 0L;

        EphemeralFileChannel(EphemeralFileData data, FileStillOpenException opened) {
            this.data = data;
            this.openedAt = opened;
            data.open(this);
        }

        @Override
        public int read(ByteBuffer dst) {
            return this.data.read(this, dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.data.write(this, src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.position = newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.data.size();
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            this.data.truncate(size);
            return this;
        }

        @Override
        public void force(boolean metaData) {
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            long prev = this.position;
            this.position = position;
            try {
                int n = this.data.read(this, dst);
                return n;
            }
            finally {
                this.position = prev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            long prev = this.position;
            this.position = position;
            try {
                int n = this.data.write(this, src);
                return n;
            }
            finally {
                this.position = prev;
            }
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            if (!this.data.lock()) {
                return null;
            }
            return new EphemeralFileLock(this, this.data);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            if (!this.data.lock()) {
                throw new IOException("Locked");
            }
            return new EphemeralFileLock(this, this.data);
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.data.close(this);
        }
    }

    private static class FileStillOpenException
    extends Exception {
        FileStillOpenException(String filename) {
            super("File still open: [" + filename + "]");
        }
    }
}

