/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Predicate;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.KillSubProcess;
import org.neo4j.test.subprocess.SubProcess;

public abstract class BreakPoint
implements DebuggerDeadlockCallback {
    final Event event;
    final String type;
    private final String method;
    private final String[] args;
    private final AtomicInteger count = new AtomicInteger();
    volatile boolean enabled = false;
    private EventRequest request = null;
    public static final Predicate<StackTraceElement[]> ALL = new Predicate<StackTraceElement[]>(){

        public boolean accept(StackTraceElement[] item) {
            return true;
        }
    };

    public BreakPoint(Class<?> type, String method, Class<?> ... args) {
        this(Event.ENTRY, type, method, args);
    }

    public BreakPoint(Event event, Class<?> type, String method, Class<?> ... args) {
        this.event = event;
        this.type = type.getName();
        this.method = method;
        this.args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.args[i] = args[i].getName();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("BreakPoint[");
        result.append(this.type).append('#').append(this.method).append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.args[i]);
        }
        return result.append(")]").toString();
    }

    public final int invocationCount() {
        return this.count.get();
    }

    public int invocationCount(int value) {
        return this.count.getAndSet(value);
    }

    public final int resetInvocationCount() {
        return this.invocationCount(0);
    }

    final void invoke(DebugInterface debug) throws KillSubProcess {
        this.count.incrementAndGet();
        this.callback(debug);
    }

    protected abstract void callback(DebugInterface var1) throws KillSubProcess;

    @Override
    public void deadlock(DebuggedThread thread) {
        SubProcess.DebugDispatch.defaultCallback.deadlock(thread);
    }

    public synchronized boolean isEnabled() {
        if (this.request != null) {
            return this.request.isEnabled();
        }
        return this.enabled;
    }

    public synchronized BreakPoint enable() {
        this.enabled = true;
        if (this.request != null) {
            this.request.enable();
        }
        return this;
    }

    public synchronized BreakPoint disable() {
        this.enabled = false;
        if (this.request != null) {
            this.request.disable();
        }
        return this;
    }

    synchronized void setRequest(EventRequest request) {
        this.request = request;
        this.request.setEnabled(this.enabled);
    }

    void setup(ReferenceType type) {
        EventRequestManager erm = type.virtualMachine().eventRequestManager();
        for (Method method : type.methodsByName(this.method)) {
            if (!this.matches(method.name(), method.argumentTypeNames())) continue;
            switch (this.event) {
                case ENTRY: {
                    this.setRequest(erm.createBreakpointRequest(method.location()));
                    return;
                }
                case EXIT: {
                    MethodExitRequest request = erm.createMethodExitRequest();
                    request.addClassFilter(type);
                    this.setRequest(request);
                }
            }
            return;
        }
    }

    boolean matches(String name, List<String> argNames) {
        if (!name.equals(this.method)) {
            return false;
        }
        if (argNames.size() != this.args.length) {
            return false;
        }
        Iterator<String> names = argNames.iterator();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(names.next())) continue;
            return false;
        }
        return true;
    }

    public static BreakPoint stacktrace(final PrintStream out, Class<?> type, String method, Class<?> ... args) {
        return new BreakPoint(type, method, (Class[])args){

            @Override
            protected void callback(DebugInterface debug) {
                out.println("Debugger stacktrace");
                debug.printStackTrace(out);
            }
        };
    }

    private static Predicate<StackTraceElement[]> reversed(final Predicate<StackTraceElement[]> predicate) {
        return new Predicate<StackTraceElement[]>(){

            public boolean accept(StackTraceElement[] item) {
                return !predicate.accept((Object)item);
            }
        };
    }

    public static Predicate<StackTraceElement[]> stackTraceMustContainClass(final Class<?> cls) {
        return new Predicate<StackTraceElement[]>(){

            public boolean accept(StackTraceElement[] item) {
                for (StackTraceElement element : item) {
                    if (!element.getClassName().equals(cls.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<StackTraceElement[]> stackTraceMustNotContainClass(Class<?> cls) {
        return BreakPoint.reversed(BreakPoint.stackTraceMustContainClass(cls));
    }

    public static BreakPoint thatCrashesTheProcess(CountDownLatch crashNotification, int letNumberOfCallsPass, Class<?> type, String method, Class<?> ... args) {
        return BreakPoint.thatCrashesTheProcess(Event.ENTRY, crashNotification, letNumberOfCallsPass, ALL, type, method, args);
    }

    public static BreakPoint thatCrashesTheProcess(Event event, final CountDownLatch crashNotification, final int letNumberOfCallsPass, final Predicate<StackTraceElement[]> stackTraceMustContain, Class<?> type, String method, Class<?> ... args) {
        return new BreakPoint(event, type, method, (Class[])args){
            private volatile int numberOfCalls;

            @Override
            protected void callback(DebugInterface debug) throws KillSubProcess {
                if (++this.numberOfCalls <= letNumberOfCallsPass) {
                    return;
                }
                if (!stackTraceMustContain.accept((Object)debug.thread().getStackTrace())) {
                    return;
                }
                debug.thread().suspend(null);
                this.disable();
                crashNotification.countDown();
                throw KillSubProcess.withExitCode(-1);
            }
        };
    }

    public static enum Event {
        ENTRY,
        EXIT;

    }
}

