/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserterImpl;

public class BatchInserterImplTest {
    private void assumeNotWindows() {
        Assume.assumeTrue((!GraphDatabaseSetting.osIsWindows() ? 1 : 0) != 0);
    }

    @Test
    public void testHonorsPassedInParams() throws Exception {
        this.assumeNotWindows();
        Boolean memoryMappingConfig = this.createInserterAndGetMemoryMappingConfig(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.use_memory_mapped_buffers.name(), "true"}));
        Assert.assertTrue((String)"memory mapped config is active", (boolean)memoryMappingConfig);
    }

    @Test
    public void testDefaultsToNoMemoryMapping() throws Exception {
        this.assumeNotWindows();
        Boolean memoryMappingConfig = this.createInserterAndGetMemoryMappingConfig(MapUtil.stringMap((String[])new String[0]));
        Assert.assertFalse((String)"memory mapped config is active", (boolean)memoryMappingConfig);
    }

    private Boolean createInserterAndGetMemoryMappingConfig(Map<String, String> initialConfig) throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(TargetDirectory.forTest(this.getClass()).graphDbDir(true).getAbsolutePath(), initialConfig);
        NeoStore neoStore = ReflectionUtil.getPrivateField(inserter, "neoStore", NeoStore.class);
        Config config = ReflectionUtil.getPrivateField(neoStore, "conf", Config.class);
        inserter.shutdown();
        return (Boolean)config.get((GraphDatabaseSetting)GraphDatabaseSettings.use_memory_mapped_buffers);
    }
}

