/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.NodeManager;

class NodeAutoIndexerImpl
extends AbstractAutoIndexerImpl<Node> {
    static final String NODE_AUTO_INDEX = "node_auto_index";
    private Config config;
    private IndexManagerImpl indexManager;
    private NodeManager nodeManager;

    public NodeAutoIndexerImpl(Config config, IndexManagerImpl indexManager, NodeManager nodeManager) {
        this.config = config;
        this.indexManager = indexManager;
        this.nodeManager = nodeManager;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() {
        this.setEnabled(this.config.get(Configuration.node_auto_indexing));
        this.propertyKeysToInclude.addAll(this.parseConfigList(this.config.get(Configuration.node_keys_indexable)));
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    protected Index<Node> getIndexInternal() {
        return this.indexManager.getOrCreateNodeIndex(NODE_AUTO_INDEX, null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.nodeManager.addNodePropertyTracker(this);
        } else {
            this.nodeManager.removeNodePropertyTracker(this);
        }
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.BooleanSetting node_auto_indexing = GraphDatabaseSettings.node_auto_indexing;
        public static final GraphDatabaseSetting.StringSetting node_keys_indexable = GraphDatabaseSettings.node_keys_indexable;
    }
}

