/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Iterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public interface RecordStore<R extends AbstractBaseRecord> {
    public static final Predicate<AbstractBaseRecord> IN_USE = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean accept(AbstractBaseRecord item) {
            return item.inUse();
        }
    };

    public String getStorageFileName();

    public WindowPoolStats getWindowPoolStats();

    public long getHighId();

    public R getRecord(long var1);

    public void updateRecord(R var1);

    public R forceGetRecord(long var1);

    public R forceGetRaw(R var1);

    public R forceGetRaw(long var1);

    public void forceUpdateRecord(R var1);

    public void accept(Processor var1, R var2);

    public int getRecordSize();

    public int getRecordHeaderSize();

    public void close();

    public static abstract class Processor {
        private boolean continueScanning = true;

        public void stopScanning() {
            this.continueScanning = false;
        }

        public void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
            this.processRecord(NodeRecord.class, store, node);
        }

        public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
            this.processRecord(RelationshipRecord.class, store, rel);
        }

        public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
            this.processRecord(PropertyRecord.class, store, property);
        }

        public void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) {
            this.processDynamic(store, string);
        }

        public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
            this.processDynamic(store, array);
        }

        protected void processDynamic(RecordStore<DynamicRecord> store, DynamicRecord record) {
            this.processRecord(DynamicRecord.class, store, record);
        }

        public void processRelationshipType(RecordStore<RelationshipTypeRecord> store, RelationshipTypeRecord record) {
            this.processRecord(RelationshipTypeRecord.class, store, record);
        }

        public void processPropertyIndex(RecordStore<PropertyIndexRecord> store, PropertyIndexRecord record) {
            this.processRecord(PropertyIndexRecord.class, store, record);
        }

        protected <R extends AbstractBaseRecord> void processRecord(Class<R> type, RecordStore<R> store, R record) {
            throw new UnsupportedOperationException(this + " does not process " + type.getSimpleName().replace("Record", "") + " records");
        }

        public <R extends AbstractBaseRecord> Iterable<R> scan(final RecordStore<R> store, final Predicate<? super R> ... filters) {
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new PrefetchingIterator<R>(){
                        final long highId;
                        int id;
                        {
                            this.highId = store.getHighId();
                            this.id = 0;
                        }

                        @Override
                        protected R fetchNextOrNull() {
                            block0: while ((long)this.id <= this.highId && this.id >= 0) {
                                if (!Processor.this.continueScanning) {
                                    return null;
                                }
                                Object record = Processor.this.getRecord(store, this.id++);
                                for (Predicate filter : filters) {
                                    if (!filter.accept(record)) continue block0;
                                }
                                return record;
                            }
                            return null;
                        }
                    };
                }
            };
        }

        protected <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id) {
            return store.forceGetRecord(id);
        }

        public static <R extends AbstractBaseRecord> Iterable<R> scanById(final RecordStore<R> store, Iterable<Long> ids) {
            return new IterableWrapper<R, Long>(ids){

                @Override
                protected R underlyingObjectToObject(Long id) {
                    return store.forceGetRecord(id);
                }
            };
        }

        public <R extends AbstractBaseRecord> void applyById(RecordStore<R> store, Iterable<Long> ids) {
            for (AbstractBaseRecord record : Processor.scanById(store, ids)) {
                store.accept(this, record);
            }
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, Predicate<? super R> ... filters) {
            this.apply(store, ProgressListener.NONE, filters);
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) {
            this.apply(store, progressListener, filters);
        }

        private final <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) {
            for (AbstractBaseRecord record : this.scan(store, filters)) {
                store.accept(this, record);
                progressListener.set(record.getLongId());
            }
            progressListener.done();
        }
    }
}

