/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class BytePrinter {
    public static void print(ByteBuffer bytes, PrintStream out) {
        BytePrinter.print(bytes, out, 0, bytes.capacity());
    }

    public static void print(ByteBuffer bytes, PrintStream out, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            BytePrinter.print(bytes.get(i), out);
            if ((i - offset + 1) % 32 == 0) {
                out.println();
                continue;
            }
            if ((i - offset + 1) % 8 == 0) {
                out.print("    ");
                continue;
            }
            out.print(" ");
        }
    }

    public static void print(byte b, PrintStream out) {
        out.print(BytePrinter.hex(b));
    }

    public static String ljust(String str, int columnWidth) {
        return String.format("%-" + columnWidth + "s", str);
    }

    public static String rjust(String str, int columnWidth) {
        return String.format("%" + columnWidth + "s", str);
    }

    public static String hex(byte b) {
        return String.format("%02x", b);
    }

    public static String hex(ByteBuffer bytes, int offset, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        BytePrinter.print(bytes, ps, offset, length);
        return baos.toString();
    }

    public static String hex(ByteBuffer bytes) {
        return BytePrinter.hex(bytes, 0, bytes.capacity());
    }
}

