/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.AnnotatedFieldHarvester;

public class ConfigurationValidator {
    private AnnotatedFieldHarvester fieldHarvester = new AnnotatedFieldHarvester();
    private Map<String, GraphDatabaseSetting<?>> settings;

    public ConfigurationValidator(Iterable<Class<?>> settingsClasses) {
        this.settings = this.getSettingsFrom(settingsClasses);
    }

    public void validate(Map<String, String> rawConfig) {
        for (String key : rawConfig.keySet()) {
            if (!this.settings.containsKey(key)) continue;
            this.settings.get(key).validate(rawConfig.get(key));
        }
    }

    private Map<String, GraphDatabaseSetting<?>> getSettingsFrom(Iterable<Class<?>> settingsClasses) {
        HashMap settings = new HashMap();
        for (Class<?> clazz : settingsClasses) {
            for (Pair<Field, GraphDatabaseSetting> field : this.fieldHarvester.findStatic(clazz, GraphDatabaseSetting.class)) {
                settings.put(field.other().name(), field.other());
            }
        }
        return settings;
    }
}

