/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.AnnotatedFieldHarvester;

public class ConfigurationDefaults {
    private static AnnotatedFieldHarvester fieldHarvester = new AnnotatedFieldHarvester();
    private Iterable<Class<?>> settingsClasses;

    public static String getDefault(GraphDatabaseSetting<?> realSetting, Class<?> settingsClass) {
        for (Pair<Field, GraphDatabaseSetting> field : fieldHarvester.findStatic(settingsClass, GraphDatabaseSetting.class)) {
            if (field.other() != realSetting) continue;
            if (field.other() instanceof GraphDatabaseSetting.DefaultValue) {
                return ((GraphDatabaseSetting.DefaultValue)((Object)field.other())).getDefaultValue();
            }
            return ConfigurationDefaults.getDefaultValue(field.first());
        }
        throw new IllegalArgumentException(MessageFormat.format("Setting {0} not found in settings-class {1}", realSetting.name(), settingsClass.getName()));
    }

    private static String getDefaultValue(Field field) {
        Default defaultAnnotation = field.getAnnotation(Default.class);
        if (defaultAnnotation == null) {
            return null;
        }
        return defaultAnnotation.value();
    }

    public ConfigurationDefaults(Class<?> ... settingsClasses) {
        this(Iterables.iterable(settingsClasses));
    }

    public ConfigurationDefaults(Iterable<Class<?>> settingsClasses) {
        this.settingsClasses = settingsClasses;
    }

    public Map<String, String> apply(Map<String, String> config) {
        HashMap<String, String> configuration = new HashMap<String, String>(config);
        for (Class<?> settingsClass : this.settingsClasses) {
            for (Pair<Field, GraphDatabaseSetting> field : fieldHarvester.findStatic(settingsClass, GraphDatabaseSetting.class)) {
                GraphDatabaseSetting setting = field.other();
                String defaultValue = setting instanceof GraphDatabaseSetting.DefaultValue ? ((GraphDatabaseSetting.DefaultValue)((Object)setting)).getDefaultValue() : ConfigurationDefaults.getDefaultValue(field.first());
                if (defaultValue == null || configuration.containsKey(setting.name())) continue;
                configuration.put(setting.name(), defaultValue);
            }
        }
        return configuration;
    }
}

