/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;

abstract class AbstractPersistenceWindow
extends LockableWindow {
    private final int recordSize;
    private final long position;
    private Buffer buffer = null;
    private final int totalSize;
    private final int windowSize;

    AbstractPersistenceWindow(long position, int recordSize, int totalSize, FileChannel channel, ByteBuffer byteBuffer) {
        super(channel);
        assert (position >= 0L) : "Illegal position[" + position + "]";
        assert (recordSize > 0) : "Illegal recordSize[" + recordSize + "]";
        assert (channel != null) : "Null file channel";
        assert (totalSize >= recordSize);
        this.position = position;
        this.recordSize = recordSize;
        this.totalSize = totalSize;
        this.windowSize = totalSize / recordSize;
        this.buffer = new Buffer(this, byteBuffer);
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public Buffer getOffsettedBuffer(long id) {
        int offset = (int)(id - this.buffer.position()) * this.recordSize;
        this.buffer.setOffset(offset);
        return this.buffer;
    }

    @Override
    public long position() {
        return this.position;
    }

    void readFullWindow() {
        try {
            long fileSize = this.getFileChannel().size();
            long recordCount = fileSize / (long)this.recordSize;
            if (this.position > recordCount) {
                return;
            }
            ByteBuffer byteBuffer = this.buffer.getBuffer();
            byteBuffer.clear();
            this.getFileChannel().read(byteBuffer, this.position * (long)this.recordSize);
            byteBuffer.clear();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load position[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    private void writeContents() {
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        byteBuffer.clear();
        try {
            int count = this.getFileChannel().write(byteBuffer, this.position * (long)this.recordSize);
            assert (count == this.totalSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write record[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    @Override
    protected synchronized void writeOutAndClose() {
        this.writeContents();
        this.closed = true;
    }

    @Override
    public int size() {
        return this.windowSize;
    }

    @Override
    public void force() {
        this.writeContents();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractPersistenceWindow)) {
            return false;
        }
        return this.position() == ((AbstractPersistenceWindow)o).position();
    }

    public int hashCode() {
        return (int)this.position;
    }

    public String toString() {
        return "PersistenceRow[" + this.position + "]";
    }

    @Override
    public synchronized void close() {
        this.buffer.close();
        this.closed = true;
    }

    @Override
    void acceptContents(PersistenceRow dpw) {
        ByteBuffer sourceBuffer = dpw.getBuffer().getBuffer();
        ByteBuffer targetBuffer = this.getBuffer().getBuffer();
        targetBuffer.position((int)((dpw.position() - this.position()) * (long)this.getRecordSize()));
        sourceBuffer.clear();
        targetBuffer.put(sourceBuffer);
    }
}

