/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;

class PersistenceRow
extends LockableWindow {
    private int recordSize = -1;
    private final long position;
    private final Buffer buffer;

    PersistenceRow(long position, int recordSize, FileChannel channel) {
        super(channel);
        assert (position >= 0L) : "Illegal position[" + position + "]";
        assert (recordSize > 0) : "Illegal recordSize[" + recordSize + "]";
        assert (channel != null) : "Null file channel";
        this.position = position;
        this.recordSize = recordSize;
        this.buffer = new Buffer(this, ByteBuffer.allocate(recordSize));
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public Buffer getOffsettedBuffer(long id) {
        if (id != this.buffer.position()) {
            throw new InvalidRecordException("Id[" + id + "] not equal to buffer position[" + this.buffer.position() + "]");
        }
        return this.buffer;
    }

    @Override
    public long position() {
        return this.position;
    }

    void readFullWindow() {
        try {
            ByteBuffer byteBuffer = this.buffer.getBuffer();
            byteBuffer.clear();
            int count = this.getFileChannel().read(byteBuffer, this.position * (long)this.recordSize);
            byteBuffer.clear();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load position[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    private void writeContents() {
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        if (this.getOperationType() == OperationType.WRITE) {
            byteBuffer.clear();
            try {
                int count = this.getFileChannel().write(byteBuffer, this.position * (long)this.recordSize);
                assert (count == this.recordSize);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to write record[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
            }
        }
        byteBuffer.clear();
    }

    @Override
    protected synchronized void writeOutAndClose() {
        this.writeContents();
        this.closed = true;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void force() {
        this.writeContents();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PersistenceRow)) {
            return false;
        }
        return this.position() == ((PersistenceRow)o).position();
    }

    public int hashCode() {
        return (int)this.position;
    }

    public String toString() {
        return "PersistenceRow[" + this.position + "]";
    }

    @Override
    public synchronized void close() {
        this.buffer.close();
        this.closed = true;
    }
}

