/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.CommandRecordVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public abstract class Command
extends XaCommand {
    static Logger logger = Logger.getLogger(Command.class.getName());
    private final long key;
    private static final byte NONE = 0;
    private static final byte NODE_COMMAND = 1;
    private static final byte PROP_COMMAND = 2;
    private static final byte REL_COMMAND = 3;
    private static final byte REL_TYPE_COMMAND = 4;
    private static final byte PROP_INDEX_COMMAND = 5;
    private static final byte NEOSTORE_COMMAND = 6;

    Command(long key) {
        this.key = key;
    }

    public abstract void accept(CommandRecordVisitor var1);

    @Override
    protected void setRecovered() {
        super.setRecovered();
    }

    long getKey() {
        return this.key;
    }

    public int hashCode() {
        return (int)(this.key >>> 32 ^ this.key);
    }

    private static void writePropertyBlock(LogBuffer buffer, PropertyBlock block) throws IOException {
        byte blockSize = (byte)block.getSize();
        assert (blockSize > 0) : blockSize + " is not a valid block size value";
        buffer.put(blockSize);
        long[] propBlockValues = block.getValueBlocks();
        for (int k = 0; k < propBlockValues.length; ++k) {
            buffer.putLong(propBlockValues[k]);
        }
        if (block.isLight() || !block.getValueRecords().get(0).isCreated()) {
            buffer.putInt(0);
        } else {
            buffer.putInt(block.getValueRecords().size());
            for (int i = 0; i < block.getValueRecords().size(); ++i) {
                DynamicRecord dynRec = block.getValueRecords().get(i);
                Command.writeDynamicRecord(buffer, dynRec);
            }
        }
    }

    static void writeDynamicRecord(LogBuffer buffer, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            buffer.putLong(record.getId()).putInt(record.getType()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            buffer.put(data);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            buffer.putLong(record.getId()).putInt(record.getType()).put(inUse);
        }
    }

    static PropertyBlock readPropertyBlock(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte blockSize = buffer.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        buffer.clear();
        buffer.limit(blockSize + 4);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long[] blocks = Command.readLongs(buffer, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        int noOfDynRecs = buffer.getInt();
        assert (noOfDynRecs >= 0) : noOfDynRecs + " is not a valid value for the number of dynamic records in a property block";
        if (noOfDynRecs != 0) {
            for (int i = 0; i < noOfDynRecs; ++i) {
                DynamicRecord dr = Command.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                dr.setCreated();
                toReturn.addValueRecord(dr);
            }
            assert (toReturn.getValueRecords().size() == noOfDynRecs) : "read in " + toReturn.getValueRecords().size() + " instead of the proper " + noOfDynRecs;
        }
        return toReturn;
    }

    static DynamicRecord readDynamicRecord(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(13);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long id = buffer.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            buffer.clear();
            buffer.limit(12);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int nrOfBytes = buffer.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = buffer.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            buffer.clear();
            buffer.limit(nrOfBytes);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            byte[] data = new byte[nrOfBytes];
            buffer.get(data);
            record.setData(data);
        }
        return record;
    }

    private static long[] readLongs(ByteBuffer buffer, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = buffer.getLong();
        }
        return result;
    }

    public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        switch (commandType) {
            case 1: {
                return NodeCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 2: {
                return PropertyCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 5: {
                return PropertyIndexCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 3: {
                return RelationshipCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 4: {
                return RelationshipTypeCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 6: {
                return NeoStoreCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    abstract boolean isCreated();

    abstract boolean isDeleted();

    static class RelationshipTypeCommand
    extends Command {
        private final RelationshipTypeRecord record;
        private final RelationshipTypeStore store;

        RelationshipTypeCommand(RelationshipTypeStore store, RelationshipTypeRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipType(this.record);
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)4);
            buffer.putInt(this.record.getId()).put(inUse).putInt(this.record.getNameId());
            Collection<DynamicRecord> typeRecords = this.record.getNameRecords();
            buffer.putInt(typeRecords.size());
            for (DynamicRecord typeRecord : typeRecords) {
                RelationshipTypeCommand.writeDynamicRecord(buffer, typeRecord);
            }
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(13);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            RelationshipTypeRecord record = new RelationshipTypeRecord(id);
            record.setInUse(inUse);
            record.setNameId(buffer.getInt());
            int nrTypeRecords = buffer.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = RelationshipTypeCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addNameRecord(dr);
            }
            return new RelationshipTypeCommand(neoStore == null ? null : neoStore.getRelationshipTypeStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipTypeCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class PropertyCommand
    extends Command {
        private final PropertyRecord record;
        private final PropertyStore store;

        PropertyCommand(PropertyStore store, PropertyRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitProperty(this.record);
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public long getNodeId() {
            return this.record.getNodeId();
        }

        public long getRelId() {
            return this.record.getRelId();
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            int i;
            byte inUse;
            byte by = inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            if (this.record.getRelId() != -1L) {
                inUse = (byte)(inUse + Record.REL_PROPERTY.byteValue());
            }
            buffer.put((byte)2);
            buffer.putLong(this.record.getId());
            buffer.put(inUse);
            buffer.putLong(this.record.getNextProp()).putLong(this.record.getPrevProp());
            long nodeId = this.record.getNodeId();
            long relId = this.record.getRelId();
            if (nodeId != -1L) {
                buffer.putLong(nodeId);
            } else if (relId != -1L) {
                buffer.putLong(relId);
            } else {
                buffer.putLong(-1L);
            }
            buffer.put((byte)this.record.getPropertyBlocks().size());
            for (i = 0; i < this.record.getPropertyBlocks().size(); ++i) {
                PropertyBlock block = this.record.getPropertyBlocks().get(i);
                assert (block.getSize() > 0) : this.record + " seems kinda broken";
                Command.writePropertyBlock(buffer, block);
            }
            buffer.putInt(this.record.getDeletedRecords().size());
            for (i = 0; i < this.record.getDeletedRecords().size(); ++i) {
                DynamicRecord dynRec = this.record.getDeletedRecords().get(i);
                PropertyCommand.writeDynamicRecord(buffer, dynRec);
            }
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            long primitiveId;
            buffer.clear();
            buffer.limit(33);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            long id = buffer.getLong();
            PropertyRecord record = new PropertyRecord(id);
            byte inUseFlag = buffer.get();
            long nextProp = buffer.getLong();
            long prevProp = buffer.getLong();
            record.setNextProp(nextProp);
            record.setPrevProp(prevProp);
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            }
            boolean nodeProperty = true;
            if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
                nodeProperty = false;
            }
            if ((primitiveId = buffer.getLong()) != -1L && nodeProperty) {
                record.setNodeId(primitiveId);
            } else if (primitiveId != -1L) {
                record.setRelId(primitiveId);
            }
            buffer.clear();
            buffer.limit(1);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int nrPropBlocks = buffer.get();
            assert (nrPropBlocks >= 0);
            if (nrPropBlocks > 0) {
                record.setInUse(true);
            }
            while (nrPropBlocks-- > 0) {
                PropertyBlock block = PropertyCommand.readPropertyBlock(byteChannel, buffer);
                if (block == null) {
                    return null;
                }
                record.addPropertyBlock(block);
            }
            buffer.clear();
            buffer.limit(4);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int deletedRecords = buffer.getInt();
            assert (deletedRecords >= 0);
            while (deletedRecords-- > 0) {
                DynamicRecord read = PropertyCommand.readDynamicRecord(byteChannel, buffer);
                if (read == null) {
                    return null;
                }
                assert (!read.inUse()) : read + " is kinda weird";
                record.addDeletedRecord(read);
            }
            if (inUse && !record.inUse() || !inUse && record.inUse()) {
                throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
            }
            return new PropertyCommand(neoStore == null ? null : neoStore.getPropertyStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class PropertyIndexCommand
    extends Command {
        private final PropertyIndexRecord record;
        private final PropertyIndexStore store;

        PropertyIndexCommand(PropertyIndexStore store, PropertyIndexRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitPropertyIndex(this.record);
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)5);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            buffer.putInt(this.record.getPropertyCount()).putInt(this.record.getNameId());
            if (this.record.isLight()) {
                buffer.putInt(0);
            } else {
                Collection<DynamicRecord> keyRecords = this.record.getNameRecords();
                buffer.putInt(keyRecords.size());
                for (DynamicRecord keyRecord : keyRecords) {
                    PropertyIndexCommand.writeDynamicRecord(buffer, keyRecord);
                }
            }
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(17);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyIndexRecord record = new PropertyIndexRecord(id);
            record.setInUse(inUse);
            record.setPropertyCount(buffer.getInt());
            record.setNameId(buffer.getInt());
            int nrKeyRecords = buffer.getInt();
            for (int i = 0; i < nrKeyRecords; ++i) {
                DynamicRecord dr = PropertyIndexCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addNameRecord(dr);
            }
            return new PropertyIndexCommand(neoStore == null ? null : neoStore.getPropertyStore().getIndexStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyIndexCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class NeoStoreCommand
    extends Command {
        private final NeoStoreRecord record;
        private final NeoStore neoStore;

        NeoStoreCommand(NeoStore neoStore, NeoStoreRecord record) {
            super(-1L);
            this.neoStore = neoStore;
            this.record = record;
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            this.neoStore.setGraphNextProp(this.record.getNextProp());
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNeoStore(this.record);
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)6).putLong(this.record.getNextProp());
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(8);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            long nextProp = buffer.getLong();
            NeoStoreRecord record = new NeoStoreRecord();
            record.setNextProp(nextProp);
            return new NeoStoreCommand(neoStore, record);
        }
    }

    static class RelationshipCommand
    extends Command {
        private final RelationshipRecord record;
        private final RelationshipStore store;

        RelationshipCommand(RelationshipStore store, RelationshipRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationship(this.record);
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        long getFirstNode() {
            return this.record.getFirstNode();
        }

        long getSecondNode() {
            return this.record.getSecondNode();
        }

        boolean isRemove() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)3);
            buffer.putLong(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putLong(this.record.getFirstNode()).putLong(this.record.getSecondNode()).putInt(this.record.getType()).putLong(this.record.getFirstPrevRel()).putLong(this.record.getFirstNextRel()).putLong(this.record.getSecondPrevRel()).putLong(this.record.getSecondNextRel()).putLong(this.record.getNextProp());
            }
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            RelationshipRecord record;
            buffer.clear();
            buffer.limit(9);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            long id = buffer.getLong();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                buffer.clear();
                buffer.limit(60);
                if (byteChannel.read(buffer) != buffer.limit()) {
                    return null;
                }
                buffer.flip();
                record = new RelationshipRecord(id, buffer.getLong(), buffer.getLong(), buffer.getInt());
                record.setInUse(inUse);
                record.setFirstPrevRel(buffer.getLong());
                record.setFirstNextRel(buffer.getLong());
                record.setSecondPrevRel(buffer.getLong());
                record.setSecondNextRel(buffer.getLong());
                record.setNextProp(buffer.getLong());
            } else {
                record = new RelationshipRecord(id, -1L, -1L, -1);
                record.setInUse(false);
            }
            return new RelationshipCommand(neoStore == null ? null : neoStore.getRelationshipStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class NodeCommand
    extends Command {
        private final NodeRecord record;
        private final NodeStore store;

        NodeCommand(NodeStore store, NodeRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNode(this.record);
        }

        @Override
        boolean isCreated() {
            return this.record.isCreated();
        }

        @Override
        boolean isDeleted() {
            return !this.record.inUse();
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)1);
            buffer.putLong(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putLong(this.record.getNextRel()).putLong(this.record.getNextProp());
            }
        }

        public static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            NodeRecord record;
            buffer.clear();
            buffer.limit(9);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            long id = buffer.getLong();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if (inUseFlag == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                buffer.clear();
                buffer.limit(16);
                if (byteChannel.read(buffer) != buffer.limit()) {
                    return null;
                }
                buffer.flip();
                record = new NodeRecord(id, buffer.getLong(), buffer.getLong());
            } else {
                record = new NodeRecord(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            }
            record.setInUse(inUse);
            return new NodeCommand(neoStore == null ? null : neoStore.getNodeStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof NodeCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }
}

