/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.InterceptingWriteTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;

public class NeoStoreXaDataSource
extends LogBackedXaDataSource {
    public static final byte[] BRANCH_ID = UTF8.encode("414141");
    public static final String LOGICAL_LOG_DEFAULT_NAME = "nioneo_logical.log";
    private static Logger logger = Logger.getLogger(NeoStoreXaDataSource.class.getName());
    private final NeoStore neoStore;
    private final XaContainer xaContainer;
    private final ArrayMap<Class<?>, Store> idGenerators;
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;
    private final String storeDir;
    private final boolean readOnly;
    private Config config;
    private final List<Pair<TransactionInterceptorProvider, Object>> providers;
    private boolean logApplied = false;
    private final StringLogger msgLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoStoreXaDataSource(Config conf, StoreFactory sf, FileSystemAbstraction fileSystemAbstraction, LockManager lockManager, LockReleaser lockReleaser, StringLogger stringLogger, XaFactory xaFactory, List<Pair<TransactionInterceptorProvider, Object>> providers, DependencyResolver dependencyResolver) throws IOException {
        super(BRANCH_ID, "nioneodb");
        boolean shouldIntercept;
        this.config = conf;
        this.providers = providers;
        this.readOnly = conf.getBoolean(Configuration.read_only);
        this.lockManager = lockManager;
        this.lockReleaser = lockReleaser;
        this.msgLog = stringLogger;
        this.storeDir = conf.get(Configuration.store_dir);
        String store = conf.get(Configuration.neo_store);
        File file = new File(store);
        if (!this.readOnly && !fileSystemAbstraction.fileExists(store)) {
            this.msgLog.logMessage("Creating new db @ " + store, true);
            this.autoCreatePath(store);
            sf.createNeoStore(store).close();
        }
        TransactionFactory tf = (shouldIntercept = conf.getBoolean(Configuration.intercept_committing_transactions)) && !providers.isEmpty() ? new InterceptingTransactionFactory(dependencyResolver) : new TransactionFactory();
        this.neoStore = sf.newNeoStore(store);
        this.xaContainer = xaFactory.newXaContainer(this, conf.get(Configuration.logical_log), new CommandFactory(this.neoStore), tf, shouldIntercept && !providers.isEmpty() ? providers : null, dependencyResolver);
        try {
            if (!this.readOnly) {
                this.neoStore.setRecoveredStatus(true);
                try {
                    this.xaContainer.openLogicalLog();
                }
                finally {
                    this.neoStore.setRecoveredStatus(false);
                }
            }
            if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
                this.neoStore.makeStoreOk();
            } else {
                logger.fine("Waiting for TM to take care of recovered transactions.");
            }
            this.idGenerators = new ArrayMap(5, false, false);
            this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
            this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
            this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
            this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
            this.idGenerators.put(PropertyIndex.class, this.neoStore.getPropertyStore().getIndexStore());
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
        }
        catch (Throwable e) {
            try {
                this.neoStore.close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    private void autoCreatePath(String store) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        int index = store.lastIndexOf(fileSeparator);
        String dirs = store.substring(0, index);
        File directories = new File(dirs);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new IOException("Unable to create directory path[" + dirs + "] for Neo4j store.");
        }
    }

    public NeoStore getNeoStore() {
        return this.neoStore;
    }

    @Override
    public void close() {
        if (!this.readOnly) {
            this.neoStore.flushAll();
        }
        this.xaContainer.close();
        if (this.logApplied) {
            this.neoStore.rebuildIdGenerators();
            this.logApplied = false;
        }
        this.neoStore.close();
        logger.fine("NeoStore closed");
        this.msgLog.logMessage("NeoStore closed", true);
    }

    public StoreId getStoreId() {
        return this.neoStore.getStoreId();
    }

    @Override
    public NeoStoreXaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public long nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.neoStore.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastCommittedTxId(long txId) {
        this.neoStore.setRecoveredStatus(true);
        try {
            this.neoStore.setLastCommittedTx(txId);
        }
        finally {
            this.neoStore.setRecoveredStatus(false);
        }
    }

    ReadTransaction getReadOnlyTransaction() {
        return new ReadTransaction(this.neoStore);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<WindowPoolStats> getWindowPoolStats() {
        return this.neoStore.getAllWindowPoolStats();
    }

    @Override
    public long getLastCommittedTxId() {
        return this.neoStore.getLastCommittedTx();
    }

    @Override
    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    @Override
    public boolean setRecovered(boolean recovered) {
        boolean currentValue = this.neoStore.isInRecoveryMode();
        this.neoStore.setRecoveredStatus(true);
        return currentValue;
    }

    @Override
    public ClosableIterable<File> listStoreFiles(boolean includeLogicalLogs) {
        final ArrayList<File> files = new ArrayList<File>();
        File neostoreFile = null;
        Pattern logFilePattern = this.getXaContainer().getLogicalLog().getHistoryFileNamePattern();
        for (File dbFile : new File(this.storeDir).listFiles()) {
            String name = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if ((name.startsWith("neostore") || name.equals("index.db")) && !name.endsWith(".id")) {
                files.add(dbFile);
                continue;
            }
            if (!includeLogicalLogs || !logFilePattern.matcher(dbFile.getName()).matches()) continue;
            files.add(dbFile);
        }
        files.add(neostoreFile);
        return new ClosableIterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return files.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public void logStoreVersions() {
    }

    public void logIdUsage() {
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        private TransactionFactory() {
        }

        @Override
        public XaTransaction create(int identifier) {
            return new WriteTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.lockReleaser, NeoStoreXaDataSource.this.lockManager);
        }

        @Override
        public void recoveryComplete() {
            logger.fine("Recovery complete, all transactions have been resolved");
            logger.fine("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.neoStore.flushAll();
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            NeoStoreXaDataSource.this.neoStore.setVersion(NeoStoreXaDataSource.this.xaContainer.getLogicalLog().getHighestLogVersion());
            logger.fine("Rebuild of id generators complete.");
        }

        @Override
        public long getCurrentVersion() {
            if (this.getLogicalLog().scanIsComplete()) {
                return NeoStoreXaDataSource.this.neoStore.getVersion();
            }
            return NeoStoreXaDataSource.this.neoStore.getVersion();
        }

        @Override
        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        @Override
        public void flushAll() {
            NeoStoreXaDataSource.this.neoStore.flushAll();
        }

        @Override
        public long getLastCommittedTx() {
            return NeoStoreXaDataSource.this.neoStore.getLastCommittedTx();
        }
    }

    private class InterceptingTransactionFactory
    extends TransactionFactory {
        private final DependencyResolver dependencyResolver;

        public InterceptingTransactionFactory(DependencyResolver dependencyResolver) {
            this.dependencyResolver = dependencyResolver;
        }

        @Override
        public XaTransaction create(int identifier) {
            TransactionInterceptor first = TransactionInterceptorProvider.resolveChain(NeoStoreXaDataSource.this.providers, NeoStoreXaDataSource.this, this.dependencyResolver);
            return new InterceptingWriteTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.lockReleaser, NeoStoreXaDataSource.this.lockManager, first);
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private NeoStore neoStore = null;

        CommandFactory(NeoStore neoStore) {
            this.neoStore = neoStore;
        }

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            Command command = Command.readCommand(this.neoStore, byteChannel, buffer);
            if (command != null) {
                command.setRecovered();
            }
            return command;
        }
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreXaDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logIdUsage(log);
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreXaDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (phase.isInitialization() || phase.isExplicitlyRequested()) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        abstract void dump(NeoStoreXaDataSource var1, StringLogger.LineLogger var2);
    }

    public static abstract class Configuration
    extends LogBackedXaDataSource.Configuration {
        public static final GraphDatabaseSetting.BooleanSetting read_only = GraphDatabaseSettings.read_only;
        public static final GraphDatabaseSetting.StringSetting store_dir = AbstractGraphDatabase.Configuration.store_dir;
        public static final GraphDatabaseSetting.StringSetting neo_store = AbstractGraphDatabase.Configuration.neo_store;
        public static final GraphDatabaseSetting.StringSetting logical_log = AbstractGraphDatabase.Configuration.logical_log;
        public static final GraphDatabaseSetting.BooleanSetting intercept_committing_transactions = GraphDatabaseSettings.intercept_committing_transactions;
    }
}

