/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyType;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.util.StringLogger;

public class LegacyPropertyStoreReader {
    public static final String FROM_VERSION = "PropertyStore v0.9.9";
    public static final int RECORD_LENGTH = 25;
    private final PersistenceWindowPool windowPool;
    private final FileChannel fileChannel;

    public LegacyPropertyStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this(fs, fileName, StringLogger.DEV_NULL);
    }

    public LegacyPropertyStoreReader(FileSystemAbstraction fs, File fileName, StringLogger log) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        this.windowPool = new PersistenceWindowPool(fileName, 25, this.fileChannel, 0L, true, true, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LegacyPropertyRecord readPropertyRecord(long id) throws IOException {
        PersistenceWindow persistenceWindow = this.windowPool.acquire(id, OperationType.READ);
        try {
            boolean inUse;
            Buffer buffer = persistenceWindow.getOffsettedBuffer(id);
            long inUseByte = buffer.get();
            boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
            if (!inUse) {
                throw new IllegalArgumentException(MessageFormat.format("Record {0} not in use", id));
            }
            LegacyPropertyRecord record = new LegacyPropertyRecord(id);
            long typeInt = buffer.getInt();
            record.setType(this.getEnumType((int)typeInt & 0xFFFF));
            record.setInUse(true);
            record.setKeyIndexId(buffer.getInt());
            record.setPropBlock(buffer.getLong());
            long prevProp = buffer.getUnsignedInt();
            long prevModifier = (inUseByte & 0xF0L) << 28;
            long nextProp = buffer.getUnsignedInt();
            long nextModifier = (typeInt & 0xF0000L) << 16;
            record.setPrevProp(LegacyStore.longFromIntAndMod(prevProp, prevModifier));
            record.setNextProp(LegacyStore.longFromIntAndMod(nextProp, nextModifier));
            LegacyPropertyRecord legacyPropertyRecord = record;
            return legacyPropertyRecord;
        }
        finally {
            this.windowPool.release(persistenceWindow);
        }
    }

    private LegacyPropertyType getEnumType(int type) {
        return LegacyPropertyType.getPropertyType(type, false);
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

